Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/fragment-configuration-fields/TextField", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../prop-types/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.TextField = void 0;

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../../../prop-types/index");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _objectWithoutProperties(source, excluded) {
      if (source == null) return {};var target = _objectWithoutPropertiesLoose(source, excluded);var key, i;if (Object.getOwnPropertySymbols) {
        var sourceSymbolKeys = Object.getOwnPropertySymbols(source);for (i = 0; i < sourceSymbolKeys.length; i++) {
          key = sourceSymbolKeys[i];if (excluded.indexOf(key) >= 0) continue;if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;target[key] = source[key];
        }
      }return target;
    }

    function _objectWithoutPropertiesLoose(source, excluded) {
      if (source == null) return {};var target = {};var sourceKeys = Object.keys(source);var key, i;for (i = 0; i < sourceKeys.length; i++) {
        key = sourceKeys[i];if (excluded.indexOf(key) >= 0) continue;target[key] = source[key];
      }return target;
    }

    function _extends() {
      _extends = Object.assign || function (target) {
        for (var i = 1; i < arguments.length; i++) {
          var source = arguments[i];for (var key in source) {
            if (Object.prototype.hasOwnProperty.call(source, key)) {
              target[key] = source[key];
            }
          }
        }return target;
      };return _extends.apply(this, arguments);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var TextField = function TextField(_ref) {
      var field = _ref.field,
          onValueSelect = _ref.onValueSelect,
          value = _ref.value;

      var _useState = (0, _react.useState)(''),
          _useState2 = _slicedToArray(_useState, 2),
          errorMessage = _useState2[0],
          setErrorMessage = _useState2[1];

      var initialValue = value === undefined ? field.defaultValue === undefined ? '' : field.defaultValue : value;

      var _useState3 = (0, _react.useState)(initialValue),
          _useState4 = _slicedToArray(_useState3, 2),
          nextValue = _useState4[0],
          setNextValue = _useState4[1];

      var _parseTypeOptions = parseTypeOptions(field.typeOptions),
          _parseTypeOptions$add = _parseTypeOptions.additionalProps,
          additionalProps = _parseTypeOptions$add === void 0 ? {} : _parseTypeOptions$add,
          _parseTypeOptions$typ = _parseTypeOptions.type,
          type = _parseTypeOptions$typ === void 0 ? 'text' : _parseTypeOptions$typ;

      return (/*#__PURE__*/_react.default.createElement(_form.default.Group, {
          className: errorMessage ? 'has-error' : ''
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: field.name
        }, field.label), /*#__PURE__*/_react.default.createElement(_form.ClayInput, _extends({
          id: field.name,
          onBlur: function onBlur(event) {
            if (event.target.checkValidity()) {
              setErrorMessage('');

              if (nextValue !== initialValue) {
                onValueSelect(field.name, nextValue);
              }
            }
          },
          onChange: function onChange(event) {
            if (event.target.validity.valid) {
              setErrorMessage('');
            } else {
              var validationErrorMessage = field.typeOptions && field.typeOptions.validation && field.typeOptions.validation.errorMessage || Liferay.Language.get('you-have-entered-invalid-data');
              setErrorMessage(validationErrorMessage);
            }

            setNextValue(event.target.value);
          },
          placeholder: field.typeOptions ? field.typeOptions.placeholder : '',
          sizing: "sm",
          type: type,
          value: nextValue
        }, additionalProps)), errorMessage && /*#__PURE__*/_react.default.createElement(_form.default.FeedbackGroup, null, /*#__PURE__*/_react.default.createElement(_form.default.FeedbackItem, null, /*#__PURE__*/_react.default.createElement(_form.default.FeedbackIndicator, {
          symbol: "exclamation-full"
        }), errorMessage)))
      );
    };

    exports.TextField = TextField;

    function parseTypeOptions() {
      var typeOptions = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};

      if (!typeOptions.validation) {
        return {
          type: 'text'
        };
      }

      var _typeOptions$validati = typeOptions.validation,
          validationType = _typeOptions$validati.type,
          properties = _objectWithoutProperties(_typeOptions$validati, ["type"]);

      var result = {
        additionalProps: {},
        type: 'text'
      };

      if (!validationType || validationType === 'text') {
        result.type = 'text';

        if (Number.isInteger(properties.minLength)) {
          result.additionalProps.minLength = properties.minLength;
        }

        if (Number.isInteger(properties.maxLength)) {
          result.additionalProps.maxLength = properties.maxLength;
        }
      }

      if (validationType === 'pattern') {
        result.additionalProps = {
          pattern: typeOptions.validation.regexp
        };
      }

      if (validationType === 'url' || validationType === 'email') {
        result.type = validationType;

        if (Number.isInteger(properties.minLength)) {
          result.additionalProps.minLength = properties.minLength;
        }

        if (Number.isInteger(properties.maxLength)) {
          result.additionalProps.maxLength = properties.maxLength;
        }
      }

      if (validationType === 'number') {
        result.type = validationType;

        if (Number.isInteger(properties.min)) {
          result.additionalProps.min = properties.min;
        }

        if (Number.isInteger(properties.max)) {
          result.additionalProps.max = properties.max;
        }
      }

      return result;
    }
    //# sourceMappingURL=TextField.js.map
  }
});
//# sourceMappingURL=TextField.js.map