Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/fragment-content/FragmentContent", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../actions/setFragmentEditables', '../../selectors/selectCanConfigureWidgets', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../../utils/getFrontendTokenValue', '../../utils/getResponsiveConfig', '../../utils/loadBackgroundImage', '../CollectionItemContext', '../GlobalContext', '../UnsafeHTML', './EditableProcessorContext', './getAllEditables', './resolveEditableValue'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _setFragmentEditables = _interopRequireDefault(require("../../actions/setFragmentEditables"));

    var _selectCanConfigureWidgets = _interopRequireDefault(require("../../selectors/selectCanConfigureWidgets"));

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

    var _index = require("../../store/index");

    var _getFrontendTokenValue = require("../../utils/getFrontendTokenValue");

    var _getResponsiveConfig = require("../../utils/getResponsiveConfig");

    var _loadBackgroundImage = _interopRequireDefault(require("../../utils/loadBackgroundImage"));

    var _CollectionItemContext = require("../CollectionItemContext");

    var _GlobalContext = require("../GlobalContext");

    var _UnsafeHTML = _interopRequireDefault(require("../UnsafeHTML"));

    var _EditableProcessorContext = require("./EditableProcessorContext");

    var _getAllEditables = _interopRequireDefault(require("./getAllEditables"));

    var _resolveEditableValue = _interopRequireDefault(require("./resolveEditableValue"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var FragmentContent = function FragmentContent(_ref) {
      var className = _ref.className,
          elementRef = _ref.elementRef,
          fragmentEntryLinkId = _ref.fragmentEntryLinkId,
          getPortals = _ref.getPortals,
          item = _ref.item,
          _ref$withinTopper = _ref.withinTopper,
          withinTopper = _ref$withinTopper === void 0 ? false : _ref$withinTopper;
      var dispatch = (0, _index.useDispatch)();
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      var isProcessorEnabled = (0, _EditableProcessorContext.useIsProcessorEnabled)();
      var globalContext = (0, _GlobalContext.useGlobalContext)();
      var toControlsId = (0, _CollectionItemContext.useToControlsId)();
      var getFieldValue = (0, _CollectionItemContext.useGetFieldValue)();
      var canConfigureWidgets = (0, _index.useSelector)(_selectCanConfigureWidgets.default);
      /**
       * Updates editables array for the rendered fragment.
       * @param {HTMLElement} [nextFragmentElement] Fragment element
       *  If not specified, fragmentElement state is used instead.
       * @return {Array} Updated editables array
       */

      var onRender = (0, _react.useCallback)(function (fragmentElement) {
        var updatedEditableValues = [];

        if (isMounted()) {
          updatedEditableValues = (0, _getAllEditables.default)(fragmentElement);
        }

        dispatch((0, _setFragmentEditables.default)(fragmentEntryLinkId, toControlsId(item.itemId), updatedEditableValues));
        return updatedEditableValues;
      }, [dispatch, fragmentEntryLinkId, isMounted, item, toControlsId]);
      var fragmentEntryLink = (0, _index.useSelectorCallback)(function (state) {
        return state.fragmentEntryLinks[fragmentEntryLinkId];
      }, [fragmentEntryLinkId]);
      var languageId = (0, _index.useSelector)(function (state) {
        return state.languageId;
      });
      var segmentsExperienceId = (0, _index.useSelector)(_selectSegmentsExperienceId.default);
      var selectedViewportSize = (0, _index.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var defaultContent = (0, _CollectionItemContext.useGetContent)(fragmentEntryLink, segmentsExperienceId);

      var _useState = (0, _react.useState)(defaultContent),
          _useState2 = _slicedToArray(_useState, 2),
          content = _useState2[0],
          setContent = _useState2[1];
      /* eslint-disable-next-line react-hooks/exhaustive-deps */

      var editableValues = fragmentEntryLink ? fragmentEntryLink.editableValues : {};
      var fragmentEntryLinkError = fragmentEntryLink === null || fragmentEntryLink === void 0 ? void 0 : fragmentEntryLink.error;
      (0, _react.useEffect)(function () {
        if (fragmentEntryLinkError) {
          throw new Error(fragmentEntryLinkError);
        }
      }, [fragmentEntryLinkError]);
      /**
       * fragmentElement keeps a copy of the fragment real HTML,
       * we perform editableValues replacements over this copy
       * to avoid multiple re-renders, when every replacement has
       * finished, this function must be called.
       *
       * Synchronizes fragmentElement's content to the real fragment
       * content. When this happens, the real re-render is performed.
       */

      (0, _react.useEffect)(function () {
        var fragmentElement = document.createElement('div');

        if (!isProcessorEnabled()) {
          fragmentElement.innerHTML = defaultContent;
          Promise.all((0, _getAllEditables.default)(fragmentElement).map(function (editable) {
            return (0, _resolveEditableValue.default)(editableValues, editable.editableId, editable.editableValueNamespace, languageId, getFieldValue).then(function (_ref2) {
              var _ref3 = _slicedToArray(_ref2, 2),
                  value = _ref3[0],
                  editableConfig = _ref3[1];

              editable.processor.render(editable.element, value, editableConfig);
              editable.element.classList.add('page-editor__editable');
            });
          })).then(function () {
            if (isMounted() && fragmentElement) {
              setContent(fragmentElement.innerHTML);
            }
          });
        }

        return function () {
          fragmentElement = null;
        };
      }, [defaultContent, editableValues, fragmentEntryLinkId, getFieldValue, isMounted, isProcessorEnabled, languageId]);
      var responsiveConfig = (0, _getResponsiveConfig.getResponsiveConfig)(item.config, selectedViewportSize);
      var _responsiveConfig$sty = responsiveConfig.styles,
          backgroundColor = _responsiveConfig$sty.backgroundColor,
          backgroundImage = _responsiveConfig$sty.backgroundImage,
          borderColor = _responsiveConfig$sty.borderColor,
          borderRadius = _responsiveConfig$sty.borderRadius,
          borderWidth = _responsiveConfig$sty.borderWidth,
          fontFamily = _responsiveConfig$sty.fontFamily,
          fontSize = _responsiveConfig$sty.fontSize,
          fontWeight = _responsiveConfig$sty.fontWeight,
          height = _responsiveConfig$sty.height,
          marginBottom = _responsiveConfig$sty.marginBottom,
          marginLeft = _responsiveConfig$sty.marginLeft,
          marginRight = _responsiveConfig$sty.marginRight,
          marginTop = _responsiveConfig$sty.marginTop,
          maxHeight = _responsiveConfig$sty.maxHeight,
          maxWidth = _responsiveConfig$sty.maxWidth,
          minHeight = _responsiveConfig$sty.minHeight,
          minWidth = _responsiveConfig$sty.minWidth,
          opacity = _responsiveConfig$sty.opacity,
          overflow = _responsiveConfig$sty.overflow,
          paddingBottom = _responsiveConfig$sty.paddingBottom,
          paddingLeft = _responsiveConfig$sty.paddingLeft,
          paddingRight = _responsiveConfig$sty.paddingRight,
          paddingTop = _responsiveConfig$sty.paddingTop,
          shadow = _responsiveConfig$sty.shadow,
          textAlign = _responsiveConfig$sty.textAlign,
          textColor = _responsiveConfig$sty.textColor,
          width = _responsiveConfig$sty.width;

      var _useState3 = (0, _react.useState)(''),
          _useState4 = _slicedToArray(_useState3, 2),
          backgroundImageValue = _useState4[0],
          setBackgroundImageValue = _useState4[1];

      (0, _react.useEffect)(function () {
        (0, _loadBackgroundImage.default)(backgroundImage).then(setBackgroundImageValue);
      }, [backgroundImage]);
      var style = {};
      style.backgroundColor = (0, _getFrontendTokenValue.getFrontendTokenValue)(backgroundColor);
      style.border = "solid ".concat(borderWidth, "px");
      style.borderColor = (0, _getFrontendTokenValue.getFrontendTokenValue)(borderColor);
      style.borderRadius = (0, _getFrontendTokenValue.getFrontendTokenValue)(borderRadius);
      style.boxShadow = (0, _getFrontendTokenValue.getFrontendTokenValue)(shadow);
      style.color = (0, _getFrontendTokenValue.getFrontendTokenValue)(textColor);
      style.fontFamily = (0, _getFrontendTokenValue.getFrontendTokenValue)(fontFamily);
      style.fontSize = (0, _getFrontendTokenValue.getFrontendTokenValue)(fontSize);
      style.fontWeight = (0, _getFrontendTokenValue.getFrontendTokenValue)(fontWeight);
      style.height = height;
      style.maxHeight = maxHeight;
      style.maxWidth = maxWidth;
      style.minHeight = minHeight;
      style.minWidth = minWidth;
      style.opacity = opacity ? opacity / 100 : null;
      style.overflow = overflow;
      style.width = width;

      if (backgroundImageValue) {
        style.backgroundImage = "url(".concat(backgroundImageValue, ")");
        style.backgroundPosition = '50% 50%';
        style.backgroundRepeat = 'no-repeat';
        style.backgroundSize = 'cover';
      }

      return (/*#__PURE__*/_react.default.createElement(_UnsafeHTML.default, {
          className: (0, _classnames.default)(className, "mb-".concat(marginBottom || 0), "ml-".concat(marginLeft || 0), "mr-".concat(marginRight || 0), "mt-".concat(marginTop || 0), "pb-".concat(paddingBottom || 0), "pl-".concat(paddingLeft || 0), "pr-".concat(paddingRight || 0), "pt-".concat(paddingTop || 0), 'page-editor__fragment-content', _defineProperty({
            'page-editor__fragment-content--portlet-topper-hidden': !canConfigureWidgets
          }, textAlign ? textAlign.startsWith('text-') ? textAlign : "text-".concat(textAlign) : '', textAlign)),
          contentRef: elementRef,
          getPortals: getPortals,
          globalContext: globalContext,
          markup: content,
          onRender: withinTopper ? onRender : function () {},
          style: style
        })
      );
    };

    var _default = /*#__PURE__*/_react.default.memo(FragmentContent);

    exports.default = _default;
    //# sourceMappingURL=FragmentContent.js.map
  }
});
//# sourceMappingURL=FragmentContent.js.map