Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/fragment-content/FragmentContentProcessor", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../selectors/selectLanguageId', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../../thunks/updateEditableValues', '../CollectionItemContext', './EditableProcessorContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = FragmentContentProcessor;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = require("frontend-js-react-web$react");

    var _selectLanguageId = _interopRequireDefault(require("../../selectors/selectLanguageId"));

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

    var _index = require("../../store/index");

    var _updateEditableValues = _interopRequireDefault(require("../../thunks/updateEditableValues"));

    var _CollectionItemContext = require("../CollectionItemContext");

    var _EditableProcessorContext = require("./EditableProcessorContext");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function FragmentContentProcessor(_ref) {
      var fragmentEntryLinkId = _ref.fragmentEntryLinkId,
          itemId = _ref.itemId;
      var dispatch = (0, _index.useDispatch)();
      var editableProcessorClickPosition = (0, _EditableProcessorContext.useEditableProcessorClickPosition)();
      var editableProcessorUniqueId = (0, _EditableProcessorContext.useEditableProcessorUniqueId)();
      var languageId = (0, _index.useSelector)(_selectLanguageId.default);
      var segmentsExperienceId = (0, _index.useSelector)(_selectSegmentsExperienceId.default);
      var setEditableProcessorUniqueId = (0, _EditableProcessorContext.useSetEditableProcessorUniqueId)();
      var toControlsId = (0, _CollectionItemContext.useToControlsId)();
      var editable = (0, _index.useSelectorCallback)(function (state) {
        var _state$editables;

        return Object.values(((_state$editables = state.editables) === null || _state$editables === void 0 ? void 0 : _state$editables[toControlsId(itemId)]) || {}).find(function (editable) {
          return editableProcessorUniqueId === toControlsId(editable.itemId);
        });
      }, [editableProcessorUniqueId, itemId, toControlsId]);
      var editableCollectionItemId = toControlsId(editable ? editable.itemId : '');
      var editableValues = (0, _index.useSelectorCallback)(function (state) {
        return state.fragmentEntryLinks[fragmentEntryLinkId] && state.fragmentEntryLinks[fragmentEntryLinkId].editableValues;
      }, [fragmentEntryLinkId]);
      (0, _react.useEffect)(function () {
        if (!editable || !editableValues || editableCollectionItemId !== editableProcessorUniqueId) {
          return;
        }

        var editableValue = editableValues[editable.editableValueNamespace][editable.editableId];
        editable.processor.createEditor(editable.element, function (value) {
          var _editableValue$defaul, _editableValue$defaul2;

          var config = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
          var defaultValue = (_editableValue$defaul = (_editableValue$defaul2 = editableValue.defaultValue) === null || _editableValue$defaul2 === void 0 ? void 0 : _editableValue$defaul2.replace(/\s+/g, ' ').trim()) !== null && _editableValue$defaul !== void 0 ? _editableValue$defaul : '';
          var previousValue = editableValue[languageId];

          if (previousValue === value || !previousValue && value === defaultValue) {
            return;
          }

          var editableConfig = _objectSpread(_objectSpread({}, editableValue.config || {}), config);

          dispatch((0, _updateEditableValues.default)({
            editableValues: _objectSpread(_objectSpread({}, editableValues), {}, _defineProperty({}, editable.editableValueNamespace, _objectSpread(_objectSpread({}, editableValues[editable.editableValueNamespace]), {}, _defineProperty({}, editable.editableId, _objectSpread(_objectSpread({}, editableValue), {}, _defineProperty({
              config: editableConfig
            }, languageId, value)))))),
            fragmentEntryLinkId: fragmentEntryLinkId,
            segmentsExperienceId: segmentsExperienceId
          }));
        }, function () {
          if (editableCollectionItemId === editableProcessorUniqueId) {
            setEditableProcessorUniqueId(null);
          }

          editable.processor.destroyEditor(editable.element, editableValue.config);
        }, editableProcessorClickPosition);
      }, [dispatch, editable, editableCollectionItemId, editableProcessorClickPosition, editableProcessorUniqueId, editableValues, fragmentEntryLinkId, languageId, segmentsExperienceId, setEditableProcessorUniqueId]);
      return null;
    }

    FragmentContentProcessor.propTypes = {
      fragmentEntryLinkId: _propTypes.default.string.isRequired
    };
    //# sourceMappingURL=FragmentContentProcessor.js.map
  }
});
//# sourceMappingURL=FragmentContentProcessor.js.map