Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/fragment-content/resolveEditableValue", ['module', 'exports', 'require', '../../config/index', '../../services/InfoItemService'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = _default;

    var _index = require("../../config/index");

    var _InfoItemService = _interopRequireDefault(require("../../services/InfoItemService"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _default(editableValues, editableId, processorType, languageId) {
      var getFieldValue = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : _InfoItemService.default.getInfoItemFieldValue;
      var editableValue = editableValues[processorType][editableId];

      if (!editableValue) {
        return Promise.resolve(null);
      }

      var valuePromise;

      if (editableIsMappedToInfoItem(editableValue)) {
        valuePromise = getFieldValue({
          classNameId: editableValue.classNameId,
          classPK: editableValue.classPK,
          collectionFieldId: editableValue.collectionFieldId,
          fieldId: editableValue.fieldId,
          languageId: languageId
        }).catch(function () {
          return selectEditableValueContent(editableValue, languageId);
        });
      } else {
        valuePromise = Promise.resolve(selectEditableValueContent(editableValue, languageId));
      }

      var configPromise;

      if (editableIsMappedToInfoItem(editableValue.config)) {
        configPromise = getFieldValue({
          classNameId: editableValue.config.classNameId,
          classPK: editableValue.config.classPK,
          collectionFieldId: editableValue.config.collectionFieldId,
          fieldId: editableValue.config.fieldId,
          languageId: languageId
        }).then(function (href) {
          return _objectSpread(_objectSpread({}, editableValue.config), {}, {
            href: href
          });
        }).catch(function () {
          return _objectSpread({}, editableValue.config);
        });
      } else {
        configPromise = Promise.resolve(editableValue.config);
      }

      return Promise.all([valuePromise, configPromise]);
    }

    function selectEditableValueContent(editableValue, languageId) {
      var content = editableValue;

      if (content[languageId]) {
        content = content[languageId];
      } else if (content[_index.config.defaultLanguageId]) {
        content = content[_index.config.defaultLanguageId];
      }

      if (content == null || content.defaultValue) {
        content = editableValue.defaultValue;
      }

      return content;
    }

    function editableIsMappedToInfoItem(editableValue) {
      return editableValue && (editableValue.classNameId && editableValue.classPK && editableValue.fieldId || editableValue.collectionFieldId);
    }
    //# sourceMappingURL=resolveEditableValue.js.map
  }
});
//# sourceMappingURL=resolveEditableValue.js.map