Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/layout-data-items/Collection", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$react', '../../config/constants/columnSizes', '../../services/CollectionService', '../../store/index', '../CollectionItemContext', '../UnsafeHTML'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getToControlsId = getToControlsId;
    exports.fromControlsId = fromControlsId;
    exports.default = void 0;

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _columnSizes = require("../../config/constants/columnSizes");

    var _CollectionService = _interopRequireDefault(require("../../services/CollectionService"));

    var _index = require("../../store/index");

    var _CollectionItemContext = require("../CollectionItemContext");

    var _UnsafeHTML = _interopRequireDefault(require("../UnsafeHTML"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var COLLECTION_ID_DIVIDER = '$';

    function collectionIsMapped(collectionConfig) {
      return collectionConfig.collection;
    }

    function getCollectionPrefix(collectionId, index) {
      return "collection-".concat(collectionId, "-").concat(index).concat(COLLECTION_ID_DIVIDER);
    }

    function getToControlsId(collectionId, index) {
      return function (itemId) {
        if (!itemId) {
          return null;
        }

        return "".concat(getCollectionPrefix(collectionId, index)).concat(itemId);
      };
    }

    function fromControlsId(controlsItemId) {
      if (!controlsItemId) {
        return null;
      }

      var _controlsItemId$split = controlsItemId.split(COLLECTION_ID_DIVIDER),
          _controlsItemId$split2 = _slicedToArray(_controlsItemId$split, 2),
          itemId = _controlsItemId$split2[1];

      return itemId || controlsItemId;
    }

    var NotCollectionSelectedMessage = function NotCollectionSelectedMessage() {
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__collection__not-collection-selected-message"
        }, Liferay.Language.get('no-collection-selected-yet'))
      );
    };

    var Grid = function Grid(_ref) {
      var child = _ref.child,
          collection = _ref.collection,
          collectionConfig = _ref.collectionConfig,
          collectionId = _ref.collectionId,
          collectionLength = _ref.collectionLength;
      var maxNumberOfItems = Math.min(collectionLength, collectionConfig.numberOfItems);
      var numberOfRows = Math.ceil(maxNumberOfItems / collectionConfig.numberOfColumns);
      return Array.from({
        length: numberOfRows
      }).map(function (_, i) {
        return (/*#__PURE__*/_react.default.createElement(_layout.default.Row, {
            key: "row-".concat(i)
          }, Array.from({
            length: collectionConfig.numberOfColumns
          }).map(function (_, j) {
            var key = "col-".concat(i, "-").concat(j);
            var index = i * collectionConfig.numberOfColumns + j;
            return (/*#__PURE__*/_react.default.createElement(_layout.default.Col, {
                key: key,
                size: _columnSizes.COLUMN_SIZE_MODULE_PER_ROW_SIZES[collectionConfig.numberOfColumns][collectionConfig.numberOfColumns][j]
              }, index < maxNumberOfItems && /*#__PURE__*/_react.default.createElement(ColumnContext, {
                collectionConfig: collectionConfig,
                collectionId: collectionId,
                collectionItem: collection[index],
                index: index
              }, /*#__PURE__*/_react.default.cloneElement(child)))
            );
          }))
        );
      });
    };

    var ColumnContext = function ColumnContext(_ref2) {
      var children = _ref2.children,
          collectionConfig = _ref2.collectionConfig,
          collectionId = _ref2.collectionId,
          collectionItem = _ref2.collectionItem,
          index = _ref2.index;
      var contextValue = (0, _react.useMemo)(function () {
        return {
          collectionConfig: collectionConfig,
          collectionItem: collectionItem,
          collectionItemIndex: index,
          fromControlsId: index === 0 ? null : fromControlsId,
          toControlsId: index === 0 ? null : getToControlsId(collectionId, index)
        };
      }, [collectionConfig, collectionId, collectionItem, index]);
      return (/*#__PURE__*/_react.default.createElement(_CollectionItemContext.CollectionItemContextProvider, {
          value: contextValue
        }, children)
      );
    };

    var DEFAULT_COLLECTION = {
      items: [{
        defaultTitle: Liferay.Language.get('title')
      }],
      length: 1
    };

    var Collection = /*#__PURE__*/_react.default.forwardRef(function (_ref3, ref) {
      var children = _ref3.children,
          item = _ref3.item;

      var child = _react.default.Children.toArray(children)[0];

      var collectionConfig = item.config;
      var dispatch = (0, _index.useDispatch)();
      var languageId = (0, _index.useSelector)(function (state) {
        return state.languageId;
      });

      var _useState = (0, _react.useState)(DEFAULT_COLLECTION),
          _useState2 = _slicedToArray(_useState, 2),
          collection = _useState2[0],
          setCollection = _useState2[1];

      (0, _react.useEffect)(function () {
        if (collectionConfig.collection) {
          _CollectionService.default.getCollectionField({
            collection: collectionConfig.collection,
            languageId: languageId,
            listItemStyle: collectionConfig.listItemStyle || null,
            listStyle: collectionConfig.listStyle,
            onNetworkStatus: dispatch,
            size: collectionConfig.numberOfItems,
            templateKey: collectionConfig.templateKey || null
          }).then(function (response) {
            var _response$items;

            setCollection(response.length > 0 && ((_response$items = response.items) === null || _response$items === void 0 ? void 0 : _response$items.length) > 0 ? response : DEFAULT_COLLECTION);
          }).catch(function (error) {});
        }
      }, [collectionConfig.collection, collectionConfig.listItemStyle, collectionConfig.listStyle, collectionConfig.numberOfItems, collectionConfig.templateKey, dispatch, languageId]);
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__collection",
          ref: ref
        }, !collectionIsMapped(collectionConfig) ? /*#__PURE__*/_react.default.createElement(NotCollectionSelectedMessage, null) : collection.content ? /*#__PURE__*/_react.default.createElement(_UnsafeHTML.default, {
          markup: collection.content
        }) : /*#__PURE__*/_react.default.createElement(Grid, {
          child: child,
          collection: collection.items,
          collectionConfig: collectionConfig,
          collectionId: item.itemId,
          collectionLength: collection.items.length
        }))
      );
    });

    var _default = Collection;
    exports.default = _default;
    //# sourceMappingURL=Collection.js.map
  }
});
//# sourceMappingURL=Collection.js.map