Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/layout-data-items/Column", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../prop-types/index', '../../selectors/selectCanUpdateItemConfiguration', '../../selectors/selectCanUpdatePageStructure', '../../store/index', '../../utils/getResponsiveColumnSize', '../ResizeContext'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _index = require("../../../prop-types/index");

    var _selectCanUpdateItemConfiguration = _interopRequireDefault(require("../../selectors/selectCanUpdateItemConfiguration"));

    var _selectCanUpdatePageStructure = _interopRequireDefault(require("../../selectors/selectCanUpdatePageStructure"));

    var _index2 = require("../../store/index");

    var _getResponsiveColumnSize = require("../../utils/getResponsiveColumnSize");

    var _ResizeContext = require("../ResizeContext");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var Column = /*#__PURE__*/_react.default.forwardRef(function (_ref, ref) {
      var children = _ref.children,
          className = _ref.className,
          item = _ref.item;
      var canUpdateItemConfiguration = (0, _index2.useSelector)(_selectCanUpdateItemConfiguration.default);
      var canUpdatePageStructure = (0, _index2.useSelector)(_selectCanUpdatePageStructure.default);
      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var updatedLayoutData = (0, _ResizeContext.useUpdatedLayoutDataContext)();
      var itemConfig = updatedLayoutData ? updatedLayoutData.items[item.itemId].config : item.config;
      var columnSize = (0, _getResponsiveColumnSize.getResponsiveColumnSize)(itemConfig, selectedViewportSize);
      var columnContent = canUpdatePageStructure || canUpdateItemConfiguration ? /*#__PURE__*/_react.default.createElement("div", {
        className: "page-editor__col__border"
      }, children) : children;
      return (/*#__PURE__*/_react.default.createElement(_layout.default.Col, {
          className: (0, _classnames.default)(className, {
            empty: !item.children.length
          }),
          ref: ref,
          size: columnSize
        }, columnContent)
      );
    });

    var _default = Column;
    exports.default = _default;
    //# sourceMappingURL=Column.js.map
  }
});
//# sourceMappingURL=Column.js.map