Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/layout-data-items/ColumnWithControls", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web', 'frontend-js-react-web$react', '../../../prop-types/index', '../../config/constants/viewportSizes', '../../selectors/selectCanUpdateItemConfiguration', '../../selectors/selectCanUpdatePageStructure', '../../selectors/selectSegmentsExperienceId', '../../store/index', '../../thunks/resizeColumns', '../../utils/getResponsiveColumnSize', '../../utils/getResponsiveConfig', '../Controls', '../GlobalContext', '../ResizeContext', '../TopperEmpty', './Column'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = exports.updateNewLayoutDataContext = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../../../prop-types/index");

    var _viewportSizes = require("../../config/constants/viewportSizes");

    var _selectCanUpdateItemConfiguration = _interopRequireDefault(require("../../selectors/selectCanUpdateItemConfiguration"));

    var _selectCanUpdatePageStructure = _interopRequireDefault(require("../../selectors/selectCanUpdatePageStructure"));

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../../selectors/selectSegmentsExperienceId"));

    var _index2 = require("../../store/index");

    var _resizeColumns = _interopRequireDefault(require("../../thunks/resizeColumns"));

    var _getResponsiveColumnSize = require("../../utils/getResponsiveColumnSize");

    var _getResponsiveConfig = require("../../utils/getResponsiveConfig");

    var _Controls = require("../Controls");

    var _GlobalContext = require("../GlobalContext");

    var _ResizeContext = require("../ResizeContext");

    var _TopperEmpty = _interopRequireDefault(require("../TopperEmpty"));

    var _Column = _interopRequireDefault(require("./Column"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var ROW_SIZE = 12;

    var getNewResponsiveConfig = function getNewResponsiveConfig(size, config, viewportSize) {
      return viewportSize === _viewportSizes.VIEWPORT_SIZES.desktop ? _objectSpread(_objectSpread({}, config), {}, {
        size: size
      }) : _objectSpread(_objectSpread({}, config), {}, _defineProperty({}, viewportSize, {
        size: size
      }));
    };

    var updateNewLayoutDataContext = function updateNewLayoutDataContext(layoutDataContext, columnConfig, selectedViewportSize) {
      var newColumnConfig = Object.keys(columnConfig).reduce(function (acc, columnId) {
        return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, columnId, _objectSpread(_objectSpread({}, layoutDataContext.items[columnId]), {}, {
          config: getNewResponsiveConfig(columnConfig[columnId].size, columnConfig[columnId].config, selectedViewportSize)
        })));
      }, {});
      return _objectSpread(_objectSpread({}, layoutDataContext), {}, {
        items: _objectSpread(_objectSpread({}, layoutDataContext.items), newColumnConfig)
      });
    };

    exports.updateNewLayoutDataContext = updateNewLayoutDataContext;

    var ColumnWithControls = /*#__PURE__*/_react.default.forwardRef(function (_ref, ref) {
      var children = _ref.children,
          item = _ref.item;
      var dispatch = (0, _index2.useDispatch)();

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          isInitialResponsiveConfig = _useState2[0],
          setIsInitialResponsiveConfig = _useState2[1];

      var resizeInfo = (0, _react.useRef)();
      var canUpdateItemConfiguration = (0, _index2.useSelector)(_selectCanUpdateItemConfiguration.default);
      var layoutData = (0, _index2.useSelector)(function (state) {
        return state.layoutData;
      });
      var parentItem = layoutData.items[item.parentId];
      var canUpdatePageStructure = (0, _index2.useSelector)(_selectCanUpdatePageStructure.default);
      var globalContext = (0, _GlobalContext.useGlobalContext)();
      var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId.default);

      var _useState3 = (0, _react.useState)(null),
          _useState4 = _slicedToArray(_useState3, 2),
          selectedColumn = _useState4[0],
          setColumnSelected = _useState4[1];

      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var resizing = (0, _ResizeContext.useResizeContext)();
      var setResizing = (0, _ResizeContext.useSetResizeContext)();
      var setUpdatedLayoutData = (0, _ResizeContext.useSetUpdatedLayoutDataContext)();
      var updatedLayoutData = (0, _ResizeContext.useUpdatedLayoutDataContext)();
      var columnIndex = parentItem.children.indexOf(item.itemId);
      var layoutDataContext = updatedLayoutData || layoutData;

      var columnRangeIsComplete = function columnRangeIsComplete(columnRange) {
        var sum = columnRange.map(function (columnId) {
          return (0, _getResponsiveColumnSize.getResponsiveColumnSize)(layoutDataContext.items[columnId].config, selectedViewportSize);
        }).reduce(function (acc, value) {
          return acc + value;
        }, 0);
        return sum % ROW_SIZE === 0;
      };

      var isLastColumnOfRow = function isLastColumnOfRow() {
        return columnRangeIsComplete(parentItem.children.slice(columnIndex + 1));
      };

      var isFirstColumnOfRow = function isFirstColumnOfRow(newColumnIndex) {
        return columnRangeIsComplete(parentItem.children.slice(0, newColumnIndex || columnIndex));
      };

      var getPreviousResizableColumnId = function getPreviousResizableColumnId() {
        var previousResizableColumns = parentItem.children.slice(0, columnIndex).filter(function (columnId) {
          return (0, _getResponsiveColumnSize.getResponsiveColumnSize)(layoutData.items[columnId].config, selectedViewportSize) > 1;
        });
        return previousResizableColumns[previousResizableColumns.length - 1];
      };

      var setInitialResponsiveConfig = function setInitialResponsiveConfig(columns) {
        var columnsInfo = columns.reduce(function (acc, column) {
          return _objectSpread(_objectSpread({}, acc), {}, _defineProperty({}, column.itemId, {
            config: column.config,
            size: (0, _getResponsiveColumnSize.getResponsiveColumnSize)(column.config, selectedViewportSize)
          }));
        }, {});
        layoutDataContext = updateNewLayoutDataContext(layoutDataContext, columnsInfo, selectedViewportSize);
        setIsInitialResponsiveConfig(false);
        setUpdatedLayoutData(layoutDataContext);
      };

      (0, _frontendJsReactWeb.useEventListener)('mousemove', function (event) {
        if (resizeInfo.current) {
          var _resizeInfo$current = resizeInfo.current,
              columnWidth = _resizeInfo$current.columnWidth,
              columns = _resizeInfo$current.columns,
              initialClientX = _resizeInfo$current.initialClientX,
              leftColumnConfig = _resizeInfo$current.leftColumnConfig,
              leftColumnId = _resizeInfo$current.leftColumnId,
              leftColumnInitialSize = _resizeInfo$current.leftColumnInitialSize,
              maxColumnDiff = _resizeInfo$current.maxColumnDiff,
              minColumnDiff = _resizeInfo$current.minColumnDiff,
              rightColumnConfig = _resizeInfo$current.rightColumnConfig,
              rightColumnId = _resizeInfo$current.rightColumnId,
              rightColumnInitialSize = _resizeInfo$current.rightColumnInitialSize,
              rightColumnIsFirst = _resizeInfo$current.rightColumnIsFirst;
          var clientXDiff = event.clientX - initialClientX;

          if (isInitialResponsiveConfig) {
            setInitialResponsiveConfig(columns);
          }

          if (rightColumnIsFirst && clientXDiff < 0) {
            var _updateNewLayoutDataC2;

            var newLeftColumnId;
            var newLeftColumnSize;
            var newLeftColumnConfig;


            if (leftColumnInitialSize === 1) {
              newLeftColumnId = getPreviousResizableColumnId();
              newLeftColumnConfig = layoutData.items[newLeftColumnId].config;
              newLeftColumnSize = (0, _getResponsiveColumnSize.getResponsiveColumnSize)(newLeftColumnConfig, selectedViewportSize) - 1;
            }

            if (!isLastColumnOfRow()) {
              var nextColumnId = layoutData.items[parentItem.children[columnIndex + 1]].itemId;
              var nextColumnConfig = layoutDataContext.items[nextColumnId].config;
              var nextColumnResponsiveConfig = (0, _getResponsiveColumnSize.getResponsiveColumnSize)(nextColumnConfig, selectedViewportSize);

              layoutDataContext = updateNewLayoutDataContext(layoutDataContext, _defineProperty({}, nextColumnId, {
                config: nextColumnConfig,
                size: nextColumnResponsiveConfig + rightColumnInitialSize
              }), selectedViewportSize);
            }

            layoutDataContext = updateNewLayoutDataContext(layoutDataContext, (_updateNewLayoutDataC2 = {}, _defineProperty(_updateNewLayoutDataC2, newLeftColumnId || leftColumnId, {
              config: newLeftColumnConfig || leftColumnConfig,
              size: newLeftColumnSize || leftColumnInitialSize - 1
            }), _defineProperty(_updateNewLayoutDataC2, rightColumnId, {
              config: rightColumnConfig,
              size: 1
            }), _updateNewLayoutDataC2), selectedViewportSize);
            setUpdatedLayoutData(layoutDataContext);
            resizeInfo.current = null;
            setResizing(false);
            setColumnSelected(null);
            dispatch((0, _resizeColumns.default)({
              layoutData: layoutDataContext,
              rowItemId: parentItem.itemId,
              segmentsExperienceId: segmentsExperienceId
            })).then(function () {
              setUpdatedLayoutData(null);
            });
          } else if (!rightColumnIsFirst) {
            var _updateNewLayoutDataC3;

            var columnDiff = Math.min(maxColumnDiff, Math.max(minColumnDiff, Math.round(clientXDiff / columnWidth)));

            var _leftColumnSize = leftColumnInitialSize + columnDiff;

            var _rightColumnSize = rightColumnInitialSize - columnDiff;

            if (rightColumnInitialSize - columnDiff === 0) {
              _leftColumnSize = leftColumnInitialSize + rightColumnInitialSize;
              _rightColumnSize = ROW_SIZE;
            }

            layoutDataContext = updateNewLayoutDataContext(layoutDataContext, (_updateNewLayoutDataC3 = {}, _defineProperty(_updateNewLayoutDataC3, leftColumnId, {
              config: leftColumnConfig,
              size: _leftColumnSize
            }), _defineProperty(_updateNewLayoutDataC3, rightColumnId, {
              config: rightColumnConfig,
              size: _rightColumnSize
            }), _updateNewLayoutDataC3), selectedViewportSize);
            setUpdatedLayoutData(layoutDataContext);
          }
        }
      }, false, globalContext.document.body);
      (0, _frontendJsReactWeb.useEventListener)('mouseup', function () {
        if (resizeInfo.current) {
          resizeInfo.current = null;
          setColumnSelected(null);
          setResizing(false);
          dispatch((0, _resizeColumns.default)({
            layoutData: layoutDataContext,
            rowItemId: parentItem.itemId,
            segmentsExperienceId: segmentsExperienceId
          })).then(function () {
            return setUpdatedLayoutData(null);
          });
        }
      }, false, globalContext.document.body);
      (0, _frontendJsReactWeb.useEventListener)('mouseleave', function () {
        if (resizeInfo.current) {
          resizeInfo.current = null;
          setColumnSelected(null);
          setResizing(false);
          setUpdatedLayoutData(null);
        }
      }, false, globalContext.document.body);
      var isActive = (0, _Controls.useIsActive)();
      var parentItemIsActive = (0, _react.useMemo)(function () {
        return layoutData.items[item.parentId] ? isActive(item.parentId) : false;
      }, [isActive, item.parentId, layoutData.items]);
      var firstColumnOfRow = isFirstColumnOfRow(columnIndex);
      var responsiveRowConfig = (0, _getResponsiveConfig.getResponsiveConfig)(parentItem.config, selectedViewportSize);
      var isReverseOrder = responsiveRowConfig.reverseOrder && parentItem.config.numberOfColumns === 2 && responsiveRowConfig.modulesPerRow === 1;
      return (/*#__PURE__*/_react.default.createElement(_TopperEmpty.default, {
          item: item
        }, /*#__PURE__*/_react.default.createElement(_Column.default, {
          className: (0, _classnames.default)('page-editor__col', {
            'page-editor__row-overlay-grid__border': !firstColumnOfRow && resizing && selectedColumn && selectedColumn.itemId === item.itemId
          }),
          item: item,
          ref: ref
        }, (canUpdatePageStructure || canUpdateItemConfiguration) && parentItemIsActive && columnIndex !== 0 && !isReverseOrder && /*#__PURE__*/_react.default.createElement("button", {
          className: (0, _classnames.default)('btn-primary page-editor__col__resizer', {
            'page-editor__col__resizer-first': firstColumnOfRow
          }),
          onMouseDown: function handleMouseDown(event) {
            setColumnSelected(item);
            setResizing(true);
            var columns = null;
            var leftColumn = layoutData.items[parentItem.children[columnIndex - 1]];

            var leftColumnInitialSize = (0, _getResponsiveColumnSize.getResponsiveColumnSize)(leftColumn.config, selectedViewportSize);
            var rightColumnInitialSize = (0, _getResponsiveColumnSize.getResponsiveColumnSize)(item.config, selectedViewportSize);

            if (selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop) {
              columns = parentItem.children.map(function (columnId) {
                return layoutDataContext.items[columnId];
              });
              setIsInitialResponsiveConfig(!columns[0].config[selectedViewportSize].size);
            }

            resizeInfo.current = {
              columnWidth: ref.current.getBoundingClientRect().width / rightColumnInitialSize,
              columns: columns,
              initialClientX: event.clientX,
              leftColumnConfig: leftColumn.config,
              leftColumnId: leftColumn.itemId,
              leftColumnInitialSize: leftColumnInitialSize,
              maxColumnDiff: isLastColumnOfRow() ? rightColumnInitialSize : rightColumnInitialSize - 1,
              minColumnDiff: -leftColumnInitialSize + 1,
              rightColumnConfig: item.config,
              rightColumnId: item.itemId,
              rightColumnInitialSize: rightColumnInitialSize,
              rightColumnIsFirst: isFirstColumnOfRow()
            };
          },
          title: Liferay.Language.get('resize-column'),
          type: "button"
        }), children))
      );
    });

    var _default = ColumnWithControls;
    exports.default = _default;
    //# sourceMappingURL=ColumnWithControls.js.map
  }
});
//# sourceMappingURL=ColumnWithControls.js.map