Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/layout-data-items/RowWithControls", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../core/hooks/useSetRef', '../../../prop-types/index', '../../selectors/selectCanUpdateItemConfiguration', '../../store/index', '../../utils/getResponsiveColumnSize', '../../utils/getResponsiveConfig', '../ResizeContext', '../Topper', './Row'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _useSetRef3 = _interopRequireDefault(require("../../../core/hooks/useSetRef"));

    var _index = require("../../../prop-types/index");

    var _selectCanUpdateItemConfiguration = _interopRequireDefault(require("../../selectors/selectCanUpdateItemConfiguration"));

    var _index2 = require("../../store/index");

    var _getResponsiveColumnSize = require("../../utils/getResponsiveColumnSize");

    var _getResponsiveConfig = require("../../utils/getResponsiveConfig");

    var _ResizeContext = require("../ResizeContext");

    var _Topper = _interopRequireDefault(require("../Topper"));

    var _Row = _interopRequireDefault(require("./Row"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var ROW_SIZE = 12;

    var RowWithControls = /*#__PURE__*/_react.default.forwardRef(function (_ref, ref) {
      var children = _ref.children,
          item = _ref.item;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          resizing = _useState2[0],
          setResizing = _useState2[1];

      var _useState3 = (0, _react.useState)(null),
          _useState4 = _slicedToArray(_useState3, 2),
          updatedLayoutData = _useState4[0],
          setUpdatedLayoutData = _useState4[1];

      var canUpdateItemConfiguration = (0, _index2.useSelector)(_selectCanUpdateItemConfiguration.default);
      var layoutData = (0, _index2.useSelector)(function (state) {
        return state.layoutData;
      });
      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var rowResponsiveConfig = (0, _getResponsiveConfig.getResponsiveConfig)(item.config, selectedViewportSize);

      var _useSetRef = (0, _useSetRef3.default)(ref),
          _useSetRef2 = _slicedToArray(_useSetRef, 2),
          setRef = _useSetRef2[0],
          itemElement = _useSetRef2[1];

      var verticalAlignment = rowResponsiveConfig.verticalAlignment;
      var _item$config$styles = item.config.styles,
          height = _item$config$styles.height,
          maxWidth = _item$config$styles.maxWidth,
          minWidth = _item$config$styles.minWidth,
          width = _item$config$styles.width;
      return (/*#__PURE__*/_react.default.createElement(_Topper.default, {
          item: item,
          itemElement: itemElement,
          style: {
            maxWidth: maxWidth,
            minWidth: minWidth,
            width: width
          }
        }, /*#__PURE__*/_react.default.createElement(_Row.default, {
          className: (0, _classnames.default)({
            'align-bottom': verticalAlignment === 'bottom',
            'align-middle': verticalAlignment === 'middle',
            empty: isSomeRowEmpty(item, layoutData, selectedViewportSize) && !height,
            'page-editor__row': canUpdateItemConfiguration,
            'page-editor__row-overlay-grid': resizing
          }),
          item: item,
          ref: setRef
        }, /*#__PURE__*/_react.default.createElement(_ResizeContext.ResizeContextProvider, {
          value: {
            resizing: resizing,
            setResizing: setResizing,
            setUpdatedLayoutData: setUpdatedLayoutData,
            updatedLayoutData: updatedLayoutData
          }
        }, children)))
      );
    });
    /**
     * Group children item by row and then check that if some row is empty
     */

    function isSomeRowEmpty(item, layoutData, selectedViewportSize) {
      var rows = groupItemsByRow(item, layoutData, selectedViewportSize);
      return rows.some(function (row) {
        return row.every(function (item) {
          return item.children.length === 0;
        });
      });
    }

    function groupItemsByRow(item, layoutData, selectedViewportSize) {
      var rows = [];
      var row = [];
      var columnSum = 0;
      item.children.forEach(function (childId) {
        var child = layoutData.items[childId];
        var columnSize = (0, _getResponsiveColumnSize.getResponsiveColumnSize)(child.config, selectedViewportSize);
        columnSum = columnSum + columnSize;
        row.push(child);

        if (columnSum === ROW_SIZE) {
          rows.push(row);
          row = [];
          columnSum = 0;
        }
      });
      return rows;
    }

    var _default = RowWithControls;
    exports.default = _default;
    //# sourceMappingURL=RowWithControls.js.map
  }
});
//# sourceMappingURL=RowWithControls.js.map