Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/undo/getItemNameFromAction", ['module', 'exports', 'require', '../../utils/getLayoutDataItemLabel'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getItemNameFromAction = getItemNameFromAction;

    var _getLayoutDataItemLabel = _interopRequireDefault(require("../../utils/getLayoutDataItemLabel"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Obtain the name associated to the undo action,
     * for those cases where there is not name associated, returns null
     *
     * @param {object} options
     * @param {object} options.action
     * @param {object} options.state
     * @return {string|null}
     */
    function getItemNameFromAction(_ref) {
      var _state$layoutData, _action$layoutData, _state$layoutData$ite, _state$layoutData2, _action$layoutData$it, _action$layoutData2;

      var action = _ref.action,
          state = _ref.state;
      var fragmentEntryLinks = action.fragmentEntryLinks ? Object.values(action.fragmentEntryLinks).reduce(function (acc, fragmentEntryLink) {
        acc[fragmentEntryLink.fragmentEntryLinkId] = fragmentEntryLink;
        return acc;
      }, {}) : state.fragmentEntryLinks;
      var item = ((_state$layoutData = state.layoutData) === null || _state$layoutData === void 0 ? void 0 : _state$layoutData.items[action.itemId]) || ((_action$layoutData = action.layoutData) === null || _action$layoutData === void 0 ? void 0 : _action$layoutData.items[action.itemId]) || Object.values((_state$layoutData$ite = (_state$layoutData2 = state.layoutData) === null || _state$layoutData2 === void 0 ? void 0 : _state$layoutData2.items) !== null && _state$layoutData$ite !== void 0 ? _state$layoutData$ite : {}).find(function (item) {
        return item.config.fragmentEntryLinkId === action.fragmentEntryLinkId;
      }) || Object.values((_action$layoutData$it = (_action$layoutData2 = action.layoutData) === null || _action$layoutData2 === void 0 ? void 0 : _action$layoutData2.items) !== null && _action$layoutData$it !== void 0 ? _action$layoutData$it : {}).find(function (item) {
        return item.config.fragmentEntryLinkId === action.fragmentEntryLinkId;
      });

      if (!item) {
        return null;
      }

      return (0, _getLayoutDataItemLabel.default)(item, fragmentEntryLinks);
    }
    //# sourceMappingURL=getItemNameFromAction.js.map
  }
});
//# sourceMappingURL=getItemNameFromAction.js.map