Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/undo/undoMoveItem", ['module', 'exports', 'require', '../../thunks/moveItem'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.undoAction = undoAction;
    exports.getDerivedStateForUndo = getDerivedStateForUndo;

    var _moveItem = _interopRequireDefault(require("../../thunks/moveItem"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function undoAction(_ref) {
      var action = _ref.action,
          store = _ref.store;
      var itemId = action.itemId,
          parentItemId = action.parentItemId,
          position = action.position;
      var segmentsExperienceId = store.segmentsExperienceId;
      return (0, _moveItem.default)({
        itemId: itemId,
        parentItemId: parentItemId,
        position: position,
        segmentsExperienceId: segmentsExperienceId
      });
    }

    function getDerivedStateForUndo(_ref2) {
      var action = _ref2.action,
          state = _ref2.state;
      var itemId = action.itemId;
      var layoutData = state.layoutData;
      var item = layoutData.items[itemId];
      var parent = layoutData.items[item.parentId];
      var position = parent.children.indexOf(itemId);
      return {
        itemId: action.itemId,
        parentItemId: parent.itemId,
        position: position
      };
    }
    //# sourceMappingURL=undoMoveItem.js.map
  }
});
//# sourceMappingURL=undoMoveItem.js.map