Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/undo/undoUpdateFragmentConfiguration", ['module', 'exports', 'require', '../../actions/updateFragmentEntryLinkConfiguration', '../../services/FragmentService'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.undoAction = undoAction;
    exports.getDerivedStateForUndo = getDerivedStateForUndo;

    var _updateFragmentEntryLinkConfiguration = _interopRequireDefault(require("../../actions/updateFragmentEntryLinkConfiguration"));

    var _FragmentService = _interopRequireDefault(require("../../services/FragmentService"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function undoAction(_ref) {
      var action = _ref.action;
      var editableValues = action.editableValues,
          fragmentEntryLinkId = action.fragmentEntryLinkId;
      return function (dispatch) {
        return _FragmentService.default.updateConfigurationValues({
          configurationValues: editableValues,
          fragmentEntryLinkId: fragmentEntryLinkId,
          onNetworkStatus: dispatch
        }).then(function (_ref2) {
          var fragmentEntryLink = _ref2.fragmentEntryLink,
              layoutData = _ref2.layoutData;
          dispatch((0, _updateFragmentEntryLinkConfiguration.default)({
            fragmentEntryLink: fragmentEntryLink,
            fragmentEntryLinkId: fragmentEntryLinkId,
            layoutData: layoutData
          }));
        });
      };
    }

    function getDerivedStateForUndo(_ref3) {
      var action = _ref3.action,
          state = _ref3.state;
      var fragmentEntryLink = action.fragmentEntryLink;
      var previousFragmentEntryLink = state.fragmentEntryLinks[fragmentEntryLink.fragmentEntryLinkId];
      return {
        editableValues: previousFragmentEntryLink.editableValues,
        fragmentEntryLinkId: fragmentEntryLink.fragmentEntryLinkId
      };
    }
    //# sourceMappingURL=undoUpdateFragmentConfiguration.js.map
  }
});
//# sourceMappingURL=undoUpdateFragmentConfiguration.js.map