Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/components/undo/undoUpdateItemConfig", ['module', 'exports', 'require', '../../actions/updateItemConfig', '../../services/LayoutService'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.undoAction = undoAction;
    exports.getDerivedStateForUndo = getDerivedStateForUndo;

    var _updateItemConfig = _interopRequireDefault(require("../../actions/updateItemConfig"));

    var _LayoutService = _interopRequireDefault(require("../../services/LayoutService"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function undoAction(_ref) {
      var action = _ref.action,
          store = _ref.store;
      var config = action.config,
          itemId = action.itemId;
      var layoutData = store.layoutData;
      var item = layoutData.items[itemId];

      var nextLayoutData = _objectSpread(_objectSpread({}, layoutData), {}, {
        items: _objectSpread(_objectSpread({}, layoutData.items), {}, _defineProperty({}, itemId, _objectSpread(_objectSpread({}, item), {}, {
          config: config
        })))
      });

      return function (dispatch) {
        return _LayoutService.default.updateLayoutData({
          layoutData: nextLayoutData,
          onNetworkStatus: dispatch,
          segmentsExperienceId: store.segmentsExperienceId
        }).then(function () {
          dispatch((0, _updateItemConfig.default)({
            itemId: itemId,
            layoutData: nextLayoutData
          }));
        });
      };
    }

    function getDerivedStateForUndo(_ref2) {
      var action = _ref2.action,
          state = _ref2.state;
      var itemId = action.itemId;
      var layoutData = state.layoutData;
      var item = layoutData.items[itemId];
      return {
        config: item.config,
        itemId: itemId
      };
    }
    //# sourceMappingURL=undoUpdateItemConfig.js.map
  }
});
//# sourceMappingURL=undoUpdateItemConfig.js.map