Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/processors/BackgroundImageProcessor", ['module', 'exports', 'require', '../../core/openImageSelector'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _openImageSelector = require("../../core/openImageSelector");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function createEditor(element, changeCallback, destroyCallback) {
      (0, _openImageSelector.openImageSelector)(function (image) {
        return changeCallback(image && image.url ? image.url : '');
      }, destroyCallback);
    }

    function destroyEditor(_element) {}

    function render(element, value) {
      if (typeof value === 'string' || (value === null || value === void 0 ? void 0 : value.url)) {
        var _value$url;

        element.style.backgroundImage = "url(\"".concat((_value$url = value === null || value === void 0 ? void 0 : value.url) !== null && _value$url !== void 0 ? _value$url : value, "\")");
        element.style.backgroundSize = 'cover';
      }
    }

    var _default = {
      createEditor: createEditor,
      destroyEditor: destroyEditor,
      render: render
    };
    exports.default = _default;
    //# sourceMappingURL=BackgroundImageProcessor.js.map
  }
});
//# sourceMappingURL=BackgroundImageProcessor.js.map