Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/reducers/widgetsReducer", ['module', 'exports', 'require', '../actions/types', '../utils/getWidgetPath', '../utils/setWidgetUsage'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = widgetsReducer;

    var _types = require("../actions/types");

    var _getWidgetPath = require("../utils/getWidgetPath");

    var _setWidgetUsage = require("../utils/setWidgetUsage");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function widgetsReducer(widgets, action) {
      switch (action.type) {
        case _types.ADD_FRAGMENT_ENTRY_LINKS:
          {
            var fragmentEntryLinks = action.fragmentEntryLinks || [];
            var nextWidgets = widgets;
            fragmentEntryLinks.forEach(function (fragmentEntryLink) {
              if (fragmentEntryLink.editableValues && fragmentEntryLink.editableValues.portletId && !fragmentEntryLink.editableValues.instanceable) {
                var widgetPath = (0, _getWidgetPath.getWidgetPath)(widgets, fragmentEntryLink.editableValues.portletId);
                nextWidgets = (0, _setWidgetUsage.setWidgetUsage)(nextWidgets, widgetPath, {
                  used: true
                });
              }
            });
            return nextWidgets;
          }

        case _types.ADD_ITEM:
          {
            var portletIds = action.portletIds || [];
            var _nextWidgets = widgets;
            portletIds.forEach(function (portletId) {
              var widgetPath = (0, _getWidgetPath.getWidgetPath)(widgets, portletId);
              _nextWidgets = (0, _setWidgetUsage.setWidgetUsage)(_nextWidgets, widgetPath, {
                used: true
              });
            });
            return _nextWidgets;
          }

        case _types.DELETE_ITEM:
          {
            var _portletIds = action.portletIds || [];

            var _nextWidgets2 = widgets;

            _portletIds.forEach(function (portletId) {
              var widgetPath = (0, _getWidgetPath.getWidgetPath)(widgets, portletId);
              _nextWidgets2 = (0, _setWidgetUsage.setWidgetUsage)(_nextWidgets2, widgetPath, {
                used: false
              });
            });

            return _nextWidgets2;
          }

        case _types.DELETE_WIDGETS:
          {
            var _nextWidgets3 = widgets;
            action.fragmentEntryLinks.forEach(function (fragmentEntryLink) {
              if (fragmentEntryLink.editableValues && fragmentEntryLink.editableValues.portletId && !fragmentEntryLink.editableValues.instanceable) {
                var widgetPath = (0, _getWidgetPath.getWidgetPath)(_nextWidgets3, fragmentEntryLink.editableValues.portletId);
                _nextWidgets3 = (0, _setWidgetUsage.setWidgetUsage)(_nextWidgets3, widgetPath, {
                  used: false
                });
              }
            });
            return _nextWidgets3;
          }

        default:
          return widgets;
      }
    }
    //# sourceMappingURL=widgetsReducer.js.map
  }
});
//# sourceMappingURL=widgetsReducer.js.map