Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/selectors/selectAvailablePanels", ['module', 'exports', 'require', '../config/constants/viewportSizes'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = selectAvailablePanels;
    exports.RESPONSIVE_PANELS = exports.CONTENT_CHANGE_PANELS = void 0;

    var _viewportSizes = require("../config/constants/viewportSizes");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var CONTENT_CHANGE_PANELS = ['comments', 'contents', 'page-structure'];
    exports.CONTENT_CHANGE_PANELS = CONTENT_CHANGE_PANELS;
    var RESPONSIVE_PANELS = ['comments', 'contents', 'page-structure'];
    /**
     * @param {Array<Array<string>>} panels
     */

    exports.RESPONSIVE_PANELS = RESPONSIVE_PANELS;

    function selectAvailablePanels(panels) {
      /**
       * @param {{ permissions: import("../../types/ActionKeys").ActionKeysMap, selectedViewportSize: string }} state
       */
      return function (_ref) {
        var permissions = _ref.permissions,
            selectedViewportSize = _ref.selectedViewportSize;

        if (permissions.LOCKED_SEGMENTS_EXPERIMENT || !permissions.UPDATE) {
          return panels.map(function (group) {
            return group.filter(function (panelId) {
              return CONTENT_CHANGE_PANELS.includes(panelId);
            });
          }).filter(function (group) {
            return group.length;
          });
        } else if (selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop) {
          return panels.map(function (group) {
            return group.filter(function (panelId) {
              return RESPONSIVE_PANELS.includes(panelId);
            });
          }).filter(function (group) {
            return group.length;
          });
        }

        return panels;
      };
    }
    //# sourceMappingURL=selectAvailablePanels.js.map
  }
});
//# sourceMappingURL=selectAvailablePanels.js.map