Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/services/FragmentService", ['module', 'exports', 'require', '../config/index', './serviceFetch'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _index = require("../config/index");

    var _serviceFetch = _interopRequireDefault(require("./serviceFetch"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * @typedef FragmentComment
     * @property {object} author
     * @property {string} body
     * @property {number} commentId
     * @property {string} dateDescription
     * @property {boolean} edited
     * @property {string} modifiedDescription
     * @property {boolean} resolved
     */

    /**
     * @typedef FragmentEntryLink
     * @property {string} content
     * @property {string} fragmentEntryLinkId
     */
    var _default = {
      /**
       * Adds a new Fragment to the current layout
       * @param {object} options
       * @param {string} options.body Body of the comment
       * @param {string} options.fragmentEntryLinkId Id of the Fragment
       * @param {function} options.onNetworkStatus
       * @param {number} [options.parentCommentId=0]
       * @return {Promise<FragmentComment>} Created FragmentComment
       */
      addComment: function addComment(_ref) {
        var body = _ref.body,
            fragmentEntryLinkId = _ref.fragmentEntryLinkId,
            onNetworkStatus = _ref.onNetworkStatus,
            _ref$parentCommentId = _ref.parentCommentId,
            parentCommentId = _ref$parentCommentId === void 0 ? 0 : _ref$parentCommentId;
        return (0, _serviceFetch.default)(_index.config.addFragmentEntryLinkCommentURL, {
          body: {
            body: body,
            fragmentEntryLinkId: fragmentEntryLinkId,
            parentCommentId: parentCommentId
          }
        }, onNetworkStatus);
      },

      /**
       * Adds a new Fragment Composition to the selected collection
       * @param {object} options
       * @param {string} options.description Fragment composition description
       * @param {string} options.fragmentCollectionId Fragment collection ID
       * @param {string} options.itemId Item ID to create a composition from
       * @param {string} options.name Fragment composition name
       * @param {function} options.onNetworkStatus
       * @param {string} options.previewImageURL Fragment composition preview image url
       * @param {boolean} options.saveInlineContent Save inline editable content
       * @param {boolean} options.saveMappingConfiguration Save fields mapping configuration
       * @param {string} options.segmentsExperienceId Current segmentsExperienceId
       * @return {Promise<FragmentComposition>} Created FragmentComposition
       */
      addFragmentComposition: function addFragmentComposition(_ref2) {
        var description = _ref2.description,
            fragmentCollectionId = _ref2.fragmentCollectionId,
            itemId = _ref2.itemId,
            name = _ref2.name,
            onNetworkStatus = _ref2.onNetworkStatus,
            previewImageURL = _ref2.previewImageURL,
            saveInlineContent = _ref2.saveInlineContent,
            saveMappingConfiguration = _ref2.saveMappingConfiguration,
            segmentsExperienceId = _ref2.segmentsExperienceId;
        return (0, _serviceFetch.default)(_index.config.addFragmentCompositionURL, {
          body: {
            description: description,
            fragmentCollectionId: fragmentCollectionId,
            itemId: itemId,
            name: name,
            previewImageURL: previewImageURL,
            saveInlineContent: saveInlineContent,
            saveMappingConfiguration: saveMappingConfiguration,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus, {
          requestGenerateDraft: true
        });
      },

      /**
       * Adds a new Fragment to the current layout
       * @param {object} options
       * @param {string} options.fragmentEntryKey Key of the Fragment
       * @param {string} options.groupId GroupId that wraps the Fragment
       * @param {function} options.onNetworkStatus
       * @param {string} options.parentItemId
       * @param {number} options.position
       * @param {string} options.segmentsExperienceId Current segmentsExperienceId
       * @param {string} options.type Type of the Fragment to add
       * @return {Promise<{ addedItemId: string, fragmentEntryLink: FragmentEntryLink, layoutData: object }>} Created FragmentEntryLink
       */
      addFragmentEntryLink: function addFragmentEntryLink(_ref3) {
        var fragmentEntryKey = _ref3.fragmentEntryKey,
            groupId = _ref3.groupId,
            onNetworkStatus = _ref3.onNetworkStatus,
            parentItemId = _ref3.parentItemId,
            position = _ref3.position,
            segmentsExperienceId = _ref3.segmentsExperienceId;
        return (0, _serviceFetch.default)(_index.config.addFragmentEntryLinkURL, {
          body: {
            fragmentEntryKey: fragmentEntryKey,
            groupId: groupId,
            parentItemId: parentItemId,
            position: position,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus, {
          requestGenerateDraft: true
        });
      },

      /**
       * Adds a new Fragment Composition to the current layout
       * @param {object} options
       * @param {string} options.fragmentEntryKey Key of the Fragment composition
       * @param {string} options.groupId GroupId that wraps the Fragment
       * @param {function} options.onNetworkStatus
       * @param {string} options.parentItemId
       * @param {number} options.position
       * @param {string} options.segmentsExperienceId Current segmentsExperienceId
       * @param {string} options.type Type of the Fragment to add
       * @return {Promise<{ fragmentEntryLinks: FragmentEntryLink[], layoutData: object }>} Created FragmentEntryLinks
       */
      addFragmentEntryLinks: function addFragmentEntryLinks(_ref4) {
        var fragmentEntryKey = _ref4.fragmentEntryKey,
            groupId = _ref4.groupId,
            onNetworkStatus = _ref4.onNetworkStatus,
            parentItemId = _ref4.parentItemId,
            position = _ref4.position,
            segmentsExperienceId = _ref4.segmentsExperienceId;
        return (0, _serviceFetch.default)(_index.config.addFragmentEntryLinksURL, {
          body: {
            fragmentEntryKey: fragmentEntryKey,
            groupId: groupId,
            parentItemId: parentItemId,
            position: position,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus, {
          requestGenerateDraft: true
        });
      },

      /**
       * Deletes a fragment comment
       * @param {object} options
       * @param {string} options.commentId Id of the comment
       * @param {function} options.onNetworkStatus
       * @return {Promise<void>}
       */
      deleteComment: function deleteComment(_ref5) {
        var commentId = _ref5.commentId,
            onNetworkStatus = _ref5.onNetworkStatus;
        return (0, _serviceFetch.default)(_index.config.deleteFragmentEntryLinkCommentURL, {
          body: {
            commentId: commentId
          }
        }, onNetworkStatus);
      },

      /**
       * Duplicates a fragmentEntryLink
       * @param {object} options
       * @param {string} options.itemId id of the item
       * @param {function} options.onNetworkStatus
       * @param {string} options.segmentsExperienceId Experience id
       */
      duplicateItem: function duplicateItem(_ref6) {
        var itemId = _ref6.itemId,
            onNetworkStatus = _ref6.onNetworkStatus,
            segmentsExperienceId = _ref6.segmentsExperienceId;
        return (0, _serviceFetch.default)(_index.config.duplicateItemURL, {
          body: {
            itemId: itemId,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus, {
          requestGenerateDraft: true
        });
      },

      /**
       * Edits a fragment comment
       * @param {object} options
       * @param {string} options.body Body of the comment
       * @param {string} options.commentId Id of the comment
       * @param {function} options.onNetworkStatus
       * @param {boolean} options.resolved Whether the comment should be marked as resolved or not
       * @return {Promise<FragmentComment>} Created FragmentComment
       */
      editComment: function editComment(_ref7) {
        var body = _ref7.body,
            commentId = _ref7.commentId,
            onNetworkStatus = _ref7.onNetworkStatus,
            resolved = _ref7.resolved;
        return (0, _serviceFetch.default)(_index.config.editFragmentEntryLinkCommentURL, {
          body: {
            body: body,
            commentId: commentId,
            resolved: resolved
          }
        }, onNetworkStatus);
      },

      /**
       * Render the content of a fragmentEntryLink
       * @param {object} options
       * @param {string} options.collectionItemClassName Class name id of the collection item
       * @param {string} options.collectionItemClassPK Class PK of the collection item
       * @param {string} options.fragmentEntryLinkId Id of the fragmentEntryLink
       * @param {function} options.onNetworkStatus
       * @param {string} options.segmentsExperienceId Experience id
       */
      renderFragmentEntryLinkContent: function renderFragmentEntryLinkContent(_ref8) {
        var collectionItemClassName = _ref8.collectionItemClassName,
            collectionItemClassPK = _ref8.collectionItemClassPK,
            fragmentEntryLinkId = _ref8.fragmentEntryLinkId,
            onNetworkStatus = _ref8.onNetworkStatus,
            segmentsExperienceId = _ref8.segmentsExperienceId;
        return (0, _serviceFetch.default)(_index.config.renderFragmentEntryURL, {
          body: {
            collectionItemClassName: collectionItemClassName,
            collectionItemClassPK: collectionItemClassPK,
            fragmentEntryLinkId: fragmentEntryLinkId,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      },

      /**
       * Update configurationValues of the fragmentEntryLink with the given fragmentEntryLinkId
       * @param {object} options
       * @param {string} options.configurationValues New configurationValues
       * @param {string} options.fragmentEntryLinkId Id of the fragmentEntryLink
       * @param {function} options.onNetworkStatus
       */
      updateConfigurationValues: function updateConfigurationValues(_ref9) {
        var configurationValues = _ref9.configurationValues,
            fragmentEntryLinkId = _ref9.fragmentEntryLinkId,
            onNetworkStatus = _ref9.onNetworkStatus;
        return (0, _serviceFetch.default)(_index.config.updateConfigurationValuesURL, {
          body: {
            editableValues: JSON.stringify(configurationValues),
            fragmentEntryLinkId: fragmentEntryLinkId
          }
        }, onNetworkStatus, {
          requestGenerateDraft: true
        });
      },

      /**
       * Update editableValues of the fragmentEntryLink with the given fragmentEntryLinkId
       * @param {object} options
       * @param {string} options.editableValues New editableValues
       * @param {string} options.fragmentEntryLinkId Id of the fragmentEntryLink
       * @param {function} options.onNetworkStatus
       */
      updateEditableValues: function updateEditableValues(_ref10) {
        var editableValues = _ref10.editableValues,
            fragmentEntryLinkId = _ref10.fragmentEntryLinkId,
            onNetworkStatus = _ref10.onNetworkStatus;
        return (0, _serviceFetch.default)(_index.config.editFragmentEntryLinkURL, {
          body: {
            editableValues: JSON.stringify(editableValues),
            fragmentEntryLinkId: fragmentEntryLinkId
          }
        }, onNetworkStatus, {
          requestGenerateDraft: true
        });
      }
    };
    exports.default = _default;
    //# sourceMappingURL=FragmentService.js.map
  }
});
//# sourceMappingURL=FragmentService.js.map