Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/services/LayoutService", ['module', 'exports', 'require', '../config/index', './serviceFetch'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _index = require("../config/index");

    var _serviceFetch = _interopRequireDefault(require("./serviceFetch"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var layoutServiceFetch = function layoutServiceFetch(url, options, onNetworkStatus) {
      return (0, _serviceFetch.default)(url, options, onNetworkStatus, {
        requestGenerateDraft: true
      });
    };

    var _default = {
      /**
       * Adds an item to layoutData
       * @param {object} options
       * @param {string} options.itemType item type
       * @param {function} options.onNetworkStatus
       * @param {object} options.parentItemId Parent to be added to
       * @param {object} options.position Position to be added to
       * @param {object} options.segmentsExperienceId
       * @return {Promise<object>}
       */
      addItem: function addItem(_ref) {
        var itemType = _ref.itemType,
            onNetworkStatus = _ref.onNetworkStatus,
            parentItemId = _ref.parentItemId,
            position = _ref.position,
            segmentsExperienceId = _ref.segmentsExperienceId;
        return layoutServiceFetch(_index.config.addItemURL, {
          body: {
            itemType: itemType,
            parentItemId: parentItemId,
            position: position,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      },

      /**
       * Change the master layout associated to the page
       * @param {object} options
       * @param {object} options.masterLayoutPlid id of the master page
       * @param {function} options.onNetworkStatus
       * @return {Promise<object>}
       */
      changeMasterLayout: function changeMasterLayout(_ref2) {
        var masterLayoutPlid = _ref2.masterLayoutPlid,
            onNetworkStatus = _ref2.onNetworkStatus;
        return layoutServiceFetch(_index.config.changeMasterLayoutURL, {
          body: {
            masterLayoutPlid: masterLayoutPlid
          }
        }, onNetworkStatus);
      },

      /**
       * Change the style book entry associated to the page
       * @param {object} options
       * @param {object} options.styleBookEntryId id of the style book entry
       * @param {function} options.onNetworkStatus
       * @return {Promise<object>}
       */
      changeStyleBookEntry: function changeStyleBookEntry(_ref3) {
        var onNetworkStatus = _ref3.onNetworkStatus,
            styleBookEntryId = _ref3.styleBookEntryId;
        return layoutServiceFetch(_index.config.changeStyleBookEntryURL, {
          body: {
            styleBookEntryId: styleBookEntryId
          }
        }, onNetworkStatus);
      },

      /**
       * Remove an item inside layoutData
       * @param {object} options
       * @param {object} options.itemId id of the item to be removed
       * @param {function} options.onNetworkStatus
       * @param {object} options.segmentsExperienceId
       * @return {Promise<object>}
       */
      deleteItem: function deleteItem(_ref4) {
        var itemId = _ref4.itemId,
            onNetworkStatus = _ref4.onNetworkStatus,
            segmentsExperienceId = _ref4.segmentsExperienceId;
        return layoutServiceFetch(_index.config.deleteItemURL, {
          body: {
            itemId: itemId,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      },

      /**
       * Marks an item for deletion
       * @param {object} options
       * @param {string} options.itemId id of the item to be updated
       * @param {string} options.portletIds the list of non instanceable portlets Ids
       * contained in the item
       * @param {string} options.segmentsExperienceId Segments experience id
       * @param {function} options.onNetworkStatus
       * @return {Promise<void>}
       */
      markItemForDeletion: function markItemForDeletion(_ref5) {
        var itemId = _ref5.itemId,
            onNetworkStatus = _ref5.onNetworkStatus,
            _ref5$portletIds = _ref5.portletIds,
            portletIds = _ref5$portletIds === void 0 ? [] : _ref5$portletIds,
            segmentsExperienceId = _ref5.segmentsExperienceId;
        return layoutServiceFetch(_index.config.markItemForDeletionURL, {
          body: {
            itemId: itemId,
            portletIds: portletIds,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      },

      /**
       * Move an item inside layoutData
       * @param {object} options
       * @param {object} options.itemId id of the item to be moved
       * @param {object} options.parentItemId id of the target parent
       * @param {object} options.position position in the parent where the item is placed
       * @param {object} options.segmentsExperienceId
       * @param {function} options.onNetworkStatus
       * @return {Promise<object>}
       */
      moveItem: function moveItem(_ref6) {
        var itemId = _ref6.itemId,
            onNetworkStatus = _ref6.onNetworkStatus,
            parentItemId = _ref6.parentItemId,
            position = _ref6.position,
            segmentsExperienceId = _ref6.segmentsExperienceId;
        return layoutServiceFetch(_index.config.moveItemURL, {
          body: {
            itemId: itemId,
            parentItemId: parentItemId,
            position: position,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      },

      /**
       * Unmarks an item for deletion
       * @param {object} options
       * @param {string} options.itemId id of the item to be updated
       * @param {string} options.segmentsExperienceId Segments experience id
       * @param {function} options.onNetworkStatus
       * @return {Promise<void>}
       */
      unmarkItemForDeletion: function unmarkItemForDeletion(_ref7) {
        var itemId = _ref7.itemId,
            onNetworkStatus = _ref7.onNetworkStatus,
            segmentsExperienceId = _ref7.segmentsExperienceId;
        return layoutServiceFetch(_index.config.unmarkItemForDeletionURL, {
          body: {
            itemId: itemId,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      },

      /**
       * Updates a config into an item
       * @param {object} options
       * @param {object} options.itemConfig Updated item config
       * @param {string} options.itemId id of the item to be updated
       * @param {string} options.segmentsExperienceId Segments experience id
       * @param {function} options.onNetworkStatus
       * @return {Promise<void>}
       */
      updateItemConfig: function updateItemConfig(_ref8) {
        var itemConfig = _ref8.itemConfig,
            itemId = _ref8.itemId,
            onNetworkStatus = _ref8.onNetworkStatus,
            segmentsExperienceId = _ref8.segmentsExperienceId;
        return layoutServiceFetch(_index.config.updateItemConfigURL, {
          body: {
            itemConfig: JSON.stringify(itemConfig),
            itemId: itemId,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      },

      /**
       * Updates layout's layoutData
       * @param {object} options
       * @param {string} options.segmentsExperienceId Current segmentsExperienceId
       * @param {object} options.layoutData New layoutData
       * @param {function} options.onNetworkStatus
       * @return {Promise<void>}
       */
      updateLayoutData: function updateLayoutData(_ref9) {
        var layoutData = _ref9.layoutData,
            onNetworkStatus = _ref9.onNetworkStatus,
            segmentsExperienceId = _ref9.segmentsExperienceId;
        return layoutServiceFetch(_index.config.updateLayoutPageTemplateDataURL, {
          body: {
            data: JSON.stringify(layoutData),
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      },

      /**
       * Updates the number of columns of a row
       * @param {object} options
       * @param {string} options.itemId id of the item to be updated
       * @param {number} options.numberOfColumns New number of columns
       * @param {string} options.segmentsExperienceId Segments experience id
       * @param {function} options.onNetworkStatus
       * @return {Promise<void>}
       */
      updateRowColumns: function updateRowColumns(_ref10) {
        var itemId = _ref10.itemId,
            numberOfColumns = _ref10.numberOfColumns,
            onNetworkStatus = _ref10.onNetworkStatus,
            segmentsExperienceId = _ref10.segmentsExperienceId;
        return layoutServiceFetch(_index.config.updateRowColumnsURL, {
          body: {
            itemId: itemId,
            numberOfColumns: numberOfColumns,
            segmentsExperienceId: segmentsExperienceId
          }
        }, onNetworkStatus);
      }
    };
    exports.default = _default;
    //# sourceMappingURL=LayoutService.js.map
  }
});
//# sourceMappingURL=LayoutService.js.map