Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/thunks/addFragment", ['module', 'exports', 'require', '../actions/addFragmentEntryLinks', '../config/constants/fragmentTypes', '../services/FragmentService'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = addFragment;

    var _addFragmentEntryLinks = _interopRequireDefault(require("../actions/addFragmentEntryLinks"));

    var _fragmentTypes = require("../config/constants/fragmentTypes");

    var _FragmentService = _interopRequireDefault(require("../services/FragmentService"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function addFragment(_ref) {
      var fragmentEntryKey = _ref.fragmentEntryKey,
          groupId = _ref.groupId,
          parentItemId = _ref.parentItemId,
          position = _ref.position,
          _ref$selectItem = _ref.selectItem,
          selectItem = _ref$selectItem === void 0 ? function () {} : _ref$selectItem,
          store = _ref.store,
          type = _ref.type;
      return function (dispatch) {
        var segmentsExperienceId = store.segmentsExperienceId;
        var params = {
          fragmentEntryKey: fragmentEntryKey,
          groupId: groupId,
          onNetworkStatus: dispatch,
          parentItemId: parentItemId,
          position: position,
          segmentsExperienceId: segmentsExperienceId,
          type: type
        };

        var updateState = function updateState(fragmentEntryLinks, layoutData, itemId) {
          dispatch((0, _addFragmentEntryLinks.default)({
            addedItemId: itemId,
            fragmentEntryLinks: fragmentEntryLinks,
            layoutData: layoutData
          }));
          selectItem(itemId);
        };

        if (type === _fragmentTypes.FRAGMENT_TYPES.composition) {
          _FragmentService.default.addFragmentEntryLinks(params).then(function (_ref2) {
            var addedItemId = _ref2.addedItemId,
                fragmentEntryLinks = _ref2.fragmentEntryLinks,
                layoutData = _ref2.layoutData;
            updateState(Object.values(fragmentEntryLinks), layoutData, addedItemId);
          });
        } else {
          _FragmentService.default.addFragmentEntryLink(params).then(function (_ref3) {
            var addedItemId = _ref3.addedItemId,
                fragmentEntryLink = _ref3.fragmentEntryLink,
                layoutData = _ref3.layoutData;
            updateState([fragmentEntryLink], layoutData, addedItemId);
          });
        }
      };
    }
    //# sourceMappingURL=addFragment.js.map
  }
});
//# sourceMappingURL=addFragment.js.map