Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/thunks/deleteItem", ['module', 'exports', 'require', '../actions/deleteItem', '../actions/deleteWidgets', '../actions/updatePageContents', '../config/constants/layoutDataItemTypes', '../services/InfoItemService', '../services/LayoutService'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = deleteItem;

    var _deleteItem = _interopRequireDefault(require("../actions/deleteItem"));

    var _deleteWidgets = _interopRequireDefault(require("../actions/deleteWidgets"));

    var _updatePageContents = _interopRequireDefault(require("../actions/updatePageContents"));

    var _layoutDataItemTypes = require("../config/constants/layoutDataItemTypes");

    var _InfoItemService = _interopRequireDefault(require("../services/InfoItemService"));

    var _LayoutService = _interopRequireDefault(require("../services/LayoutService"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function deleteItem(_ref) {
      var itemId = _ref.itemId,
          _ref$selectItem = _ref.selectItem,
          selectItem = _ref$selectItem === void 0 ? function () {} : _ref$selectItem,
          store = _ref.store;
      return function (dispatch) {
        var fragmentEntryLinks = store.fragmentEntryLinks,
            layoutData = store.layoutData,
            segmentsExperienceId = store.segmentsExperienceId;
        return markItemForDeletion({
          fragmentEntryLinks: fragmentEntryLinks,
          itemId: itemId,
          layoutData: layoutData,
          onNetworkStatus: dispatch,
          segmentsExperienceId: segmentsExperienceId
        }).then(function (_ref2) {
          var _ref2$deletedFragment = _ref2.deletedFragmentEntryLinkIds,
              deletedFragmentEntryLinkIds = _ref2$deletedFragment === void 0 ? [] : _ref2$deletedFragment,
              _ref2$portletIds = _ref2.portletIds,
              portletIds = _ref2$portletIds === void 0 ? [] : _ref2$portletIds,
              layoutData = _ref2.layoutData;
          var deletedWidgets = deletedFragmentEntryLinkIds.map(function (fragmentEntryLinkId) {
            return store.fragmentEntryLinks[fragmentEntryLinkId];
          }).filter(function (fragmentEntryLink) {
            return fragmentEntryLink.editableValues.portletId;
          });

          if (deletedWidgets.length) {
            dispatch((0, _deleteWidgets.default)(deletedWidgets));
          }

          selectItem(null);
          dispatch((0, _deleteItem.default)({
            itemId: itemId,
            layoutData: layoutData,
            portletIds: portletIds
          }));
        }).then(function () {
          _InfoItemService.default.getPageContents({
            onNetworkStatus: dispatch
          }).then(function (pageContents) {
            dispatch((0, _updatePageContents.default)({
              pageContents: pageContents
            }));
          });
        });
      };
    }

    function markItemForDeletion(_ref3) {
      var fragmentEntryLinks = _ref3.fragmentEntryLinks,
          itemId = _ref3.itemId,
          layoutData = _ref3.layoutData,
          dispatch = _ref3.onNetworkStatus,
          segmentsExperienceId = _ref3.segmentsExperienceId;
      var portletIds = findPortletIds(itemId, layoutData, fragmentEntryLinks);
      return _LayoutService.default.markItemForDeletion({
        itemId: itemId,
        onNetworkStatus: dispatch,
        portletIds: portletIds,
        segmentsExperienceId: segmentsExperienceId
      }).then(function (response) {
        return _objectSpread(_objectSpread({}, response), {}, {
          portletIds: portletIds
        });
      });
    }

    function findPortletIds(itemId, layoutData, fragmentEntryLinks) {
      var item = layoutData.items[itemId];
      var _item$config = item.config,
          config = _item$config === void 0 ? {} : _item$config,
          _item$children = item.children,
          children = _item$children === void 0 ? [] : _item$children;

      if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment && config.fragmentEntryLinkId) {
        var _fragmentEntryLinks$c = fragmentEntryLinks[config.fragmentEntryLinkId].editableValues,
            editableValues = _fragmentEntryLinks$c === void 0 ? {} : _fragmentEntryLinks$c;

        if (editableValues.portletId && !editableValues.instanceId) {
          return [editableValues.portletId];
        }
      }

      var deletedWidgets = [];
      children.forEach(function (itemId) {
        deletedWidgets.push.apply(deletedWidgets, _toConsumableArray(findPortletIds(itemId, layoutData, fragmentEntryLinks)));
      });
      return deletedWidgets;
    }
    //# sourceMappingURL=deleteItem.js.map
  }
});
//# sourceMappingURL=deleteItem.js.map