Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/thunks/multipleUndo", ['module', 'exports', 'require', '../actions/index', '../actions/types', '../components/undo/undoActions', '../config/constants/serviceNetworkStatusTypes', '../config/constants/undoTypes', '../reducers/index', './../components/undo/undoActions'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = multipleUndo;

    var _index = require("../actions/index");

    var _types = require("../actions/types");

    var _undoActions = require("../components/undo/undoActions");

    var _serviceNetworkStatusTypes = require("../config/constants/serviceNetworkStatusTypes");

    var _undoTypes = require("../config/constants/undoTypes");

    var _index2 = require("../reducers/index");

    var _undoActions2 = require("./../components/undo/undoActions");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function multipleUndo(_ref) {
      var numberOfActions = _ref.numberOfActions,
          store = _ref.store,
          type = _ref.type;
      return function (dispatch) {
        if (!store.undoHistory && !store.redoHistory) {
          return;
        }

        var isUndoAction, remainingUndos, undosToUndo, updateHistoryAction;
        var updatedStore = store;

        var multipleUndoDispatch = function multipleUndoDispatch(originalType) {
          return function (action) {
            if ((0, _undoActions2.canUndoAction)(action)) {
              updatedStore = (0, _index2.reducer)(updatedStore, _objectSpread(_objectSpread({}, action), {}, {
                actionType: action.type,
                originalType: originalType,
                type: type === _undoTypes.UNDO_TYPES.undo ? _types.ADD_REDO_ACTION : _types.ADD_UNDO_ACTION
              }));
              updatedStore = (0, _index2.reducer)(updatedStore, _objectSpread(_objectSpread(_objectSpread({}, action), isUndoAction), {}, {
                originalType: originalType
              }));
            }
          };
        };

        if (type === _undoTypes.UNDO_TYPES.undo) {
          isUndoAction = {
            isUndo: true
          };
          undosToUndo = store.undoHistory.slice(0, numberOfActions);
          remainingUndos = store.undoHistory.slice(numberOfActions, store.undoHistory.length);
          updateHistoryAction = {
            type: _types.UPDATE_UNDO_ACTIONS,
            undoHistory: remainingUndos
          };
        } else {
          isUndoAction = {
            isRedo: true
          };
          undosToUndo = store.redoHistory.slice(0, numberOfActions);
          remainingUndos = store.redoHistory.slice(numberOfActions, store.redoHistory.length);
          updateHistoryAction = {
            redoHistory: remainingUndos,
            type: _types.UPDATE_REDO_ACTIONS
          };
        }

        dispatch((0, _index.updateNetwork)({
          status: _serviceNetworkStatusTypes.SERVICE_NETWORK_STATUS_TYPES.savingDraft
        }));
        return undosToUndo.reduce(function (promise, undo) {
          return promise.then(function () {
            return (0, _undoActions.undoAction)({
              action: undo,
              store: updatedStore
            })(multipleUndoDispatch(undo.originalType || undo.type));
          });
        }, Promise.resolve()).then(function () {
          dispatch((0, _index.updateNetwork)({
            requestGenerateDraft: false,
            status: _serviceNetworkStatusTypes.SERVICE_NETWORK_STATUS_TYPES.draftSaved
          }));
          updatedStore = (0, _index2.reducer)(updatedStore, updateHistoryAction);
          dispatch({
            store: updatedStore,
            type: 'UPDATE_STORE'
          });
        }).catch(function (error) {

          dispatch((0, _index.updateNetwork)({
            error: Liferay.Language.get('an-unexpected-error-occurred'),
            status: _serviceNetworkStatusTypes.SERVICE_NETWORK_STATUS_TYPES.error
          }));
        });
      };
    }
    //# sourceMappingURL=multipleUndo.js.map
  }
});
//# sourceMappingURL=multipleUndo.js.map