Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/thunks/undo", ['module', 'exports', 'require', '../actions/types', '../components/undo/undoActions'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = undo;

    var _types = require("../actions/types");

    var _undoActions = require("../components/undo/undoActions");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toArray(arr) {
      return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var promise = Promise.resolve();

    function undo(_ref) {
      var store = _ref.store;
      return function (dispatch) {
        if (!store.undoHistory || store.undoHistory.length === 0) {
          return;
        }

        var _ref2 = store.undoHistory || [],
            _ref3 = _toArray(_ref2),
            lastUndo = _ref3[0],
            undos = _ref3.slice(1);

        dispatch({
          type: _types.UPDATE_UNDO_ACTIONS,
          undoHistory: undos
        });

        var undoDispatch = function undoDispatch(action) {
          return dispatch(_objectSpread(_objectSpread({}, action), {}, {
            isUndo: true,
            originalType: lastUndo.originalType || lastUndo.type
          }));
        };

        promise = promise.then(function () {
          return (0, _undoActions.undoAction)({
            action: lastUndo,
            store: store
          })(undoDispatch);
        });
      };
    }
    //# sourceMappingURL=undo.js.map
  }
});
//# sourceMappingURL=undo.js.map