Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/utils/dragAndDrop/getTargetPosition", ['module', 'exports', 'require', './constants/targetPosition'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = getTargetPosition;

    var _targetPosition = require("./constants/targetPosition");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Returns the cursor vertical position (extracted from provided dnd monitor)
     * @param {number} clientOffsetY
     * @param {DOMRect} hoverBoundingRect
     * @param {number} elevationBorderSize
     * @return {Array} Returns a tuple with targetPositionWithMiddle and
     *  targetPositionWithoutMiddle
     */
    function getTargetPosition(clientOffsetY, hoverBoundingRect, elevationBorderSize) {
      var hoverMiddleY = hoverBoundingRect.top + hoverBoundingRect.height / 2;
      var targetPositionWithoutMiddle = clientOffsetY < hoverMiddleY ? _targetPosition.TARGET_POSITION.TOP : _targetPosition.TARGET_POSITION.BOTTOM;
      var targetPositionWithMiddle = clientOffsetY < hoverBoundingRect.bottom - elevationBorderSize && clientOffsetY > hoverBoundingRect.top + elevationBorderSize ? _targetPosition.TARGET_POSITION.MIDDLE : targetPositionWithoutMiddle;
      return [targetPositionWithMiddle, targetPositionWithoutMiddle];
    }
    //# sourceMappingURL=getTargetPosition.js.map
  }
});
//# sourceMappingURL=getTargetPosition.js.map