Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/utils/getResponsiveConfig", ['module', 'exports', 'require', '../config/constants/viewportSizes'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getResponsiveConfig = getResponsiveConfig;

    var _viewportSizes = require("../config/constants/viewportSizes");

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var ORDERED_VIEWPORT_SIZES = [_viewportSizes.VIEWPORT_SIZES.desktop, _viewportSizes.VIEWPORT_SIZES.tablet, _viewportSizes.VIEWPORT_SIZES.landscapeMobile, _viewportSizes.VIEWPORT_SIZES.portraitMobile];

    function getResponsiveConfig(config, viewportSize) {
      var viewportSizeIndex = ORDERED_VIEWPORT_SIZES.indexOf(viewportSize);
      var responsiveConfig = {};

      for (var i = 0; i <= viewportSizeIndex; i++) {
        var viewPortSizeConfig = ORDERED_VIEWPORT_SIZES[i] === _viewportSizes.VIEWPORT_SIZES.desktop ? config : config[ORDERED_VIEWPORT_SIZES[i]];
        responsiveConfig = _objectSpread(_objectSpread(_objectSpread({}, responsiveConfig), viewPortSizeConfig), {}, {
          gutters: config.gutters,
          styles: _objectSpread(_objectSpread({}, responsiveConfig.styles), viewPortSizeConfig.styles)
        });
      }

      return responsiveConfig;
    }
    //# sourceMappingURL=getResponsiveConfig.js.map
  }
});
//# sourceMappingURL=getResponsiveConfig.js.map