Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/utils/getWidgetPath", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.getWidgetPath = getWidgetPath;

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Get widget path from the widgets tree by portletId
     */
    function getWidgetPath(widgets, portletId) {
      var path = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : [];
      var widgetPath = null;

      for (var categoryIndex = 0; categoryIndex < widgets.length; categoryIndex += 1) {
        var _widgets$categoryInde = widgets[categoryIndex],
            _widgets$categoryInde2 = _widgets$categoryInde.categories,
            categories = _widgets$categoryInde2 === void 0 ? [] : _widgets$categoryInde2,
            _widgets$categoryInde3 = _widgets$categoryInde.portlets,
            portlets = _widgets$categoryInde3 === void 0 ? [] : _widgets$categoryInde3;
        var categoryPortletIndex = portlets.findIndex(function (_portlet) {
          return _portlet.portletId === portletId;
        });
        var subCategoryPortletPath = getWidgetPath(categories, portletId, [].concat(_toConsumableArray(path), [categoryIndex, 'categories']));

        if (categoryPortletIndex !== -1) {
          widgetPath = [].concat(_toConsumableArray(path), [categoryIndex, 'portlets', categoryPortletIndex]);
        }

        if (subCategoryPortletPath) {
          widgetPath = subCategoryPortletPath;
        }
      }

      return widgetPath;
    }
    //# sourceMappingURL=getWidgetPath.js.map
  }
});
//# sourceMappingURL=getWidgetPath.js.map