Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/app/utils/loadBackgroundImage", ['module', 'exports', 'require', '../services/InfoItemService'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = loadBackgroundImage;

    var _InfoItemService = _interopRequireDefault(require("../services/InfoItemService"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function loadBackgroundImage(backgroundImage) {
      if (!backgroundImage) {
        return Promise.resolve('');
      } else if (typeof backgroundImage.url === 'string') {
        return Promise.resolve(backgroundImage.url);
      } else if (backgroundImage.fieldId) {
        return _InfoItemService.default.getInfoItemFieldValue({
          classNameId: backgroundImage.classNameId,
          classPK: backgroundImage.classPK,
          fieldId: backgroundImage.fieldId,
          onNetworkStatus: function onNetworkStatus() {}
        }).then(function (response) {
          if (response.fieldValue && response.fieldValue.url) {
            return response.fieldValue.url;
          }

          return '';
        });
      }

      return Promise.resolve('');
    }
    //# sourceMappingURL=loadBackgroundImage.js.map
  }
});
//# sourceMappingURL=loadBackgroundImage.js.map