Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/common/components/ColorPalette", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../app/config/index', '../../app/utils/useId'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = ColorPalette;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _index = require("../../app/config/index");

    var _useId = require("../../app/utils/useId");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function ColorPalette(_ref) {
      var label = _ref.label,
          onClear = _ref.onClear,
          onColorSelect = _ref.onColorSelect,
          selectedColor = _ref.selectedColor;
      var colorPaletteId = (0, _useId.useId)();
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__color-palette"
        }, label && /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: colorPaletteId
        }, label), /*#__PURE__*/_react.default.createElement("div", {
          className: "palette-container",
          id: colorPaletteId
        }, /*#__PURE__*/_react.default.createElement("ul", {
          className: "list-unstyled palette-items-container"
        }, _index.config.themeColorsCssClasses.map(function (color) {
          return (/*#__PURE__*/_react.default.createElement("li", {
              className: (0, _classnames.default)('palette-item', {
                'palette-item-selected': color === selectedColor
              }),
              key: color
            }, /*#__PURE__*/_react.default.createElement(_button.default, {
              block: true,
              className: (0, _classnames.default)("bg-".concat(color), 'palette-item-inner', 'p-1', 'rounded-circle'),
              displayType: "unstyled",
              onClick: function onClick(event) {
                return onColorSelect(color, event);
              },
              small: true,
              title: color
            }))
          );
        }))), onClear && /*#__PURE__*/_react.default.createElement(_button.default, {
          displayType: "secondary",
          onClick: onClear,
          small: true
        }, Liferay.Language.get('clear')))
      );
    }
    //# sourceMappingURL=ColorPalette.js.map
  }
});
//# sourceMappingURL=ColorPalette.js.map