Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/common/components/Editor", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-events', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../app/config/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = Editor;

    var _metalEvents = require("frontend-js-metal-web$metal-events");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../../app/config/index");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function Editor(_ref) {
      var _ref$autoFocus = _ref.autoFocus,
          autoFocus = _ref$autoFocus === void 0 ? false : _ref$autoFocus,
          configurationName = _ref.configurationName,
          id = _ref.id,
          initialValue = _ref.initialValue,
          onChange = _ref.onChange,
          placeholder = _ref.placeholder;
      var editorConfig = _index.config.defaultEditorConfigurations[configurationName].editorConfig;

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          editor = _useState2[0],
          setEditor = _useState2[1];

      var wrapperRef = (0, _react.useRef)(null);
      (0, _react.useEffect)(function () {
        if (editor) {
          var nativeEditor = editor.get('nativeEditor');

          if (!nativeEditor.getData() || !initialValue) {
            nativeEditor.setData(initialValue);
          }
        }
      }, [editor, initialValue]);
      (0, _react.useEffect)(function () {
        var editorEventHandler = new _metalEvents.EventHandler();

        if (editor && onChange) {
          var nativeEditor = editor.get('nativeEditor');
          editorEventHandler.add(nativeEditor.on('change', function () {
            return onChange(nativeEditor.getData());
          }));
          editorEventHandler.add(nativeEditor.on('actionPerformed', function () {
            return onChange(nativeEditor.getData());
          }));
        }

        return function () {
          editorEventHandler.removeAllListeners();
          editorEventHandler.dispose();
        };
      }, [editor, onChange]);
      (0, _react.useEffect)(function () {
        var newEditor = AlloyEditor.editable(wrapperRef.current, _objectSpread(_objectSpread({}, editorConfig), {}, {
          enterMode: 1,
          startupFocus: autoFocus,
          title: false
        }));
        var ready = false;
        var instanceReadyEventHandler = newEditor.get('nativeEditor').once('instanceReady', function () {
          ready = true;
          setEditor(newEditor);
        });
        return function () {
          try {
            if (ready) {
              newEditor.destroy();
              setEditor(null);
            } else {
              instanceReadyEventHandler.removeListener();
              newEditor.get('nativeEditor').once('instanceReady', function () {
                newEditor.destroy();
              });
            }
          } catch (_err) {// https://github.com/liferay/alloy-editor/issues/1306
          }
        };
      }, [autoFocus, editorConfig]);
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "alloy-editor-container",
          id: "".concat(_index.config.portletNamespace).concat(id)
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "alloy-editor alloy-editor-placeholder form-control form-control-sm page-editor__editor",
          contentEditable: false,
          "data-placeholder": placeholder,
          "data-required": false,
          id: "".concat(_index.config.portletNamespace).concat(id),
          name: id,
          ref: wrapperRef
        }))
      );
    }
    //# sourceMappingURL=Editor.js.map
  }
});
//# sourceMappingURL=Editor.js.map