Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/common/components/InlineConfirm", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', 'frontend-js-react-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', './Button'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = InlineConfirm;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Button = _interopRequireDefault(require("./Button"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function InlineConfirm(_ref) {
      var cancelButtonLabel = _ref.cancelButtonLabel,
          confirmButtonLabel = _ref.confirmButtonLabel,
          message = _ref.message,
          onCancelButtonClick = _ref.onCancelButtonClick,
          onConfirmButtonClick = _ref.onConfirmButtonClick;

      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          performingAction = _useState2[0],
          setPerformingAction = _useState2[1];

      var wrapper = (0, _react.useRef)(null);
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      (0, _react.useEffect)(function () {
        if (wrapper.current) {
          wrapper.current.focus();
        }
      }, []);
      (0, _react.useEffect)(function () {
        if (wrapper.current) {
          var confirmButton = wrapper.current.querySelector('page-editor__inline-confirm-button');

          if (confirmButton) {
            confirmButton.focus();
          }
        }

        var _handleDocumentFocusOut = function _handleDocumentFocusOut() {
          requestAnimationFrame(function () {
            if (wrapper.current && !performingAction) {
              if (!wrapper.current.contains(document.activeElement) && wrapper.current !== document.activeElement) {
                onCancelButtonClick();
              }
            }
          });
        };

        document.addEventListener('focusout', _handleDocumentFocusOut, true);
        return function () {
          return window.removeEventListener('focusout', _handleDocumentFocusOut, true);
        };
      }, [performingAction, onCancelButtonClick]);
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__inline-confirm",
          onKeyDown: function onKeyDown(e) {
            return e.key === 'Escape' && onCancelButtonClick();
          },
          ref: wrapper,
          role: "alertdialog",
          tabIndex: "-1"
        }, /*#__PURE__*/_react.default.createElement("p", {
          className: "text-center text-secondary"
        }, /*#__PURE__*/_react.default.createElement("strong", null, message)), /*#__PURE__*/_react.default.createElement(_button.default.Group, {
          spaced: true
        }, /*#__PURE__*/_react.default.createElement(_Button.default, {
          className: "page-editor__inline-confirm-button",
          disabled: performingAction,
          displayType: "primary",
          loading: performingAction,
          onClick: function _handleConfirmButtonClick() {
            if (wrapper.current) {
              wrapper.current.focus();
            }

            setPerformingAction(true);
            onConfirmButtonClick().then(function () {
              if (isMounted()) {
                setPerformingAction(false);
              }
            });
          },
          small: true
        }, confirmButtonLabel), /*#__PURE__*/_react.default.createElement(_Button.default, {
          disabled: performingAction,
          displayType: "secondary",
          onClick: onCancelButtonClick,
          small: true,
          type: "button"
        }, cancelButtonLabel)))
      );
    }
    //# sourceMappingURL=InlineConfirm.js.map
  }
});
//# sourceMappingURL=InlineConfirm.js.map