Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/core/debounceRAF", ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = debounceRAF;

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */

    /**
     * Debounces function execution until next animation frame.
     * @param {!function()} fn
     * @return {!function()}
     */
    function debounceRAF(fn) {
      return function debounced() {
        var args = arguments;
        cancelDebounce(debounced);
        debounced.id = requestAnimationFrame(function () {
          fn.apply(void 0, _toConsumableArray(args));
        });
      };
    }
    /**
     * Cancels the scheduled debounced function.
     * @param {function()} debounced
     */

    function cancelDebounce(debounced) {
      cancelAnimationFrame(debounced.id);
    }
    //# sourceMappingURL=debounceRAF.js.map
  }
});
//# sourceMappingURL=debounceRAF.js.map