Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/core/hooks/useLoad", ['module', 'exports', 'require', 'frontend-js-react-web', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = useLoad;

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var useCallback = _react.default.useCallback,
        useRef = _react.default.useRef;
    /**
     * Provides a way to load a module on demand.
     *
     * The returned `load()` function expects an identifying `key` for
     * the module and an entry point (ie. path to the module), and returns a
     * promise that resolves to the loaded module's default export.
     */

    function useLoad() {
      var modules = useRef(new Map());
      var isMounted = (0, _frontendJsReactWeb.useIsMounted)();
      return useCallback(function (key, entryPoint) {
        if (!modules.current.get(key)) {
          modules.current.set(key, new Promise(function (resolve, reject) {
            Liferay.Loader.require([entryPoint], function (Plugin) {
              if (isMounted()) {
                resolve(Plugin.default);
              }
            }, function (error) {
              if (isMounted()) {
                // Reset to allow future retries.
                modules.current.delete(key);
                reject(error);
              }
            });
          }));
        }

        return modules.current.get(key);
      }, [isMounted]);
    }
    //# sourceMappingURL=useLoad.js.map
  }
});
//# sourceMappingURL=useLoad.js.map