Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/contents/components/PageContent", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/drop-down', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/label', '@frontend-taglib-clay$clayui/layout', 'frontend-js-react-web$classnames', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../app/components/Controls', '../../../app/config/constants/editableFragmentEntryProcessor', '../../../app/config/constants/itemTypes', '../../../app/store/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = PageContent;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _dropDown = _interopRequireDefault(require("@frontend-taglib-clay$clayui/drop-down"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _label = _interopRequireDefault(require("@frontend-taglib-clay$clayui/label"));

    var _layout = _interopRequireDefault(require("@frontend-taglib-clay$clayui/layout"));

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _frontendJsWeb = require("frontend-js-web");

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Controls = require("../../../app/components/Controls");

    var _editableFragmentEntryProcessor = require("../../../app/config/constants/editableFragmentEntryProcessor");

    var _itemTypes = require("../../../app/config/constants/itemTypes");

    var _index = require("../../../app/store/index");

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _toArray(arr) {
      return _arrayWithHoles(arr) || _iterableToArray(arr) || _nonIterableRest();
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function PageContent(props) {
      var _useState = (0, _react.useState)(false),
          _useState2 = _slicedToArray(_useState, 2),
          active = _useState2[0],
          setActive = _useState2[1];

      var _props$actions = props.actions,
          editURL = _props$actions.editURL,
          permissionsURL = _props$actions.permissionsURL,
          viewUsagesURL = _props$actions.viewUsagesURL;
      var hoverItem = (0, _Controls.useHoverItem)();
      var hoveredItemId = (0, _Controls.useHoveredItemId)();
      var fragmentEntryLinks = (0, _index.useSelector)(function (state) {
        return state.fragmentEntryLinks;
      });

      var _useState3 = (0, _react.useState)(false),
          _useState4 = _slicedToArray(_useState3, 2),
          isHovered = _useState4[0],
          setIsHovered = _useState4[1];

      (0, _react.useEffect)(function () {
        if (hoveredItemId) {
          var _hoveredItemId$split = hoveredItemId.split('-'),
              _hoveredItemId$split2 = _toArray(_hoveredItemId$split),
              fragmentEntryLinkId = _hoveredItemId$split2[0],
              editableId = _hoveredItemId$split2.slice(1);

          if (fragmentEntryLinks[fragmentEntryLinkId]) {
            var fragmentEntryLink = fragmentEntryLinks[fragmentEntryLinkId];
            var editableValue = fragmentEntryLink.editableValues[_editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR];
            var editable = editableValue[editableId.join('-')];

            if (editable) {
              setIsHovered(editable.classPK === props.classPK);
            }
          }
        } else {
          setIsHovered(false);
        }
      }, [fragmentEntryLinks, hoveredItemId, props.classPK]);

      return (/*#__PURE__*/_react.default.createElement("li", {
          className: (0, _classnames.default)('page-editor__contents__page-content', {
            'page-editor__contents__page-content--mapped-item-hovered': isHovered
          }),
          onMouseLeave: function handleMouseLeave() {
            setIsHovered(false);
            hoverItem(null);
          },
          onMouseOver: function handleMouseOver() {
            setIsHovered(true);
            hoverItem("".concat(props.classNameId, "-").concat(props.classPK), {
              itemType: _itemTypes.ITEM_TYPES.mappedContent
            });
          }
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "d-flex pl-3 pr-2 py-3"
        }, /*#__PURE__*/_react.default.createElement(_layout.default.ContentCol, {
          expand: true
        }, /*#__PURE__*/_react.default.createElement("strong", {
          className: "list-group-title text-truncate"
        }, props.title), /*#__PURE__*/_react.default.createElement("span", {
          className: "small text-secondary"
        }, props.name), /*#__PURE__*/_react.default.createElement("span", {
          className: "small text-secondary"
        }, props.usagesCount === 1 ? Liferay.Language.get('used-in-1-page') : Liferay.Util.sub(Liferay.Language.get('used-in-x-pages'), props.usagesCount)), /*#__PURE__*/_react.default.createElement("div", null, props.status.hasApprovedVersion && /*#__PURE__*/_react.default.createElement(_label.default, {
          displayType: "success"
        }, Liferay.Language.get('approved')), /*#__PURE__*/_react.default.createElement(_label.default, {
          displayType: props.status.style
        }, props.status.label))), (editURL || permissionsURL || viewUsagesURL) && /*#__PURE__*/_react.default.createElement(_dropDown.default, {
          active: active,
          onActiveChange: setActive,
          trigger: /*#__PURE__*/_react.default.createElement(_button.default, {
            className: "btn-monospaced btn-sm text-secondary",
            displayType: "unstyled"
          }, /*#__PURE__*/_react.default.createElement("span", {
            className: "sr-only"
          }, Liferay.Language.get('open-actions-menu')), /*#__PURE__*/_react.default.createElement(_icon.default, {
            symbol: "ellipsis-v"
          }))
        }, /*#__PURE__*/_react.default.createElement(_dropDown.default.ItemList, null, editURL && /*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          href: editURL,
          key: "editURL"
        }, Liferay.Language.get('edit')), permissionsURL && /*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          key: "permissionsURL",
          onClick: function onClick() {
            (0, _frontendJsWeb.openModal)({
              title: Liferay.Language.get('permissions'),
              url: permissionsURL
            });
          }
        }, Liferay.Language.get('permissions')), viewUsagesURL && /*#__PURE__*/_react.default.createElement(_dropDown.default.Item, {
          key: "viewUsagesURL",
          onClick: function onClick() {
            (0, _frontendJsWeb.openModal)({
              title: Liferay.Language.get('view-usages'),
              url: viewUsagesURL
            });
          }
        }, Liferay.Language.get('view-usages'))))))
      );
    }
    //# sourceMappingURL=PageContent.js.map
  }
});
//# sourceMappingURL=PageContent.js.map