Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/experience/utils", ['module', 'exports', 'require', 'frontend-js-web', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.useDebounceCallback = useDebounceCallback;
    exports.storeModalExperienceState = storeModalExperienceState;
    exports.recoverModalExperienceState = recoverModalExperienceState;

    var _frontendJsWeb = require("frontend-js-web");

    var _react = require("frontend-js-react-web$react");

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function useDebounceCallback(callback, milliseconds) {
      var callbackRef = (0, _react.useRef)((0, _frontendJsWeb.debounce)(callback, milliseconds));
      return [callbackRef.current, function () {
        return (0, _frontendJsWeb.cancelDebounce)(callbackRef.current);
      }];
    }

    var MODAL_EXPERIENCE_STATE_KEY = 'modalExperienceState';
    /**
     * @typedef {Object} ModalExperienceState
     * @param {string} ModalExperienceState.plid
     * @param {string?} ModalExperienceState.experienceId
     * @param {string} ModalExperienceState.experienceName
     * @param {string} ModalExperienceState.segmentId
     */

    /**
     * Stores the `modalExperienceState` so it can be recovered later
     *
     * It also destroys any information previously stored for the same purpose
     *
     * @param {ModalExperienceState} modalExperienceState
     */

    function storeModalExperienceState(modalExperienceState) {
      window.sessionStorage.setItem(MODAL_EXPERIENCE_STATE_KEY, JSON.stringify(modalExperienceState));
    }
    /**
     * Rescovers the `modalExperienceState` destroying any information stored for that purpose
     *
     * @return {ModalExperienceState|null}
     */

    function recoverModalExperienceState() {
      var state = window.sessionStorage.getItem(MODAL_EXPERIENCE_STATE_KEY);

      if (state !== null) {
        window.sessionStorage.removeItem(MODAL_EXPERIENCE_STATE_KEY);
        return JSON.parse(state);
      }

      return null;
    }
    //# sourceMappingURL=utils.js.map
  }
});
//# sourceMappingURL=utils.js.map