Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/fragments-widgets/components/FragmentsSidebar", ['module', 'exports', 'require', 'frontend-js-react-web$react', '../../../app/config/constants/layoutDataItemTypes', '../../../app/store/index', '../../../common/components/SearchForm', '../../../common/components/SidebarPanelContent', '../../../common/components/SidebarPanelHeader', './SearchResultsPanel', './TabsPanel'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = FragmentsSidebar;

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _layoutDataItemTypes = require("../../../app/config/constants/layoutDataItemTypes");

    var _index = require("../../../app/store/index");

    var _SearchForm = _interopRequireDefault(require("../../../common/components/SearchForm"));

    var _SidebarPanelContent = _interopRequireDefault(require("../../../common/components/SidebarPanelContent"));

    var _SidebarPanelHeader = _interopRequireDefault(require("../../../common/components/SidebarPanelHeader"));

    var _SearchResultsPanel = _interopRequireDefault(require("./SearchResultsPanel"));

    var _TabsPanel = _interopRequireDefault(require("./TabsPanel"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    var BASIC_COMPONENT_COLLECTION = 'BASIC_COMPONENT';

    var collectionFilter = function collectionFilter(collections, searchValue) {
      var searchValueLowerCase = searchValue.toLowerCase();

      var itemFilter = function itemFilter(item) {
        return item.label.toLowerCase().indexOf(searchValueLowerCase) !== -1;
      };

      return collections.reduce(function (acc, collection) {
        if (itemFilter(collection)) {
          return [].concat(_toConsumableArray(acc), [collection]);
        } else {
          var _collection$collectio3;

          var updateCollection = _objectSpread(_objectSpread({}, collection), {}, {
            children: collection.children.filter(itemFilter)
          }, ((_collection$collectio3 = collection.collections) === null || _collection$collectio3 === void 0 ? void 0 : _collection$collectio3.length) && {
            collections: collectionFilter(collection.collections, searchValueLowerCase)
          });

          return [].concat(_toConsumableArray(acc), [updateCollection]);
        }
      }, []).filter(function hasChildren(collection) {
        var _collection$children, _collection$collectio, _collection$collectio2;

        if ((_collection$children = collection.children) === null || _collection$children === void 0 ? void 0 : _collection$children.length) {
          return true;
        }

        return (_collection$collectio = (_collection$collectio2 = collection.collections) === null || _collection$collectio2 === void 0 ? void 0 : _collection$collectio2.some(hasChildren)) !== null && _collection$collectio !== void 0 ? _collection$collectio : false;
      });
    };

    var normalizeWidget = function normalizeWidget(widget) {
      var _widget$portletItems;

      return {
        data: {
          instanceable: widget.instanceable,
          portletId: widget.portletId,
          portletItemId: widget.portletItemId || null,
          used: widget.used
        },
        disabled: !widget.instanceable && widget.used,
        icon: widget.instanceable ? 'cards2' : 'square-hole',
        itemId: widget.portletId,
        label: widget.title,
        portletItems: ((_widget$portletItems = widget.portletItems) === null || _widget$portletItems === void 0 ? void 0 : _widget$portletItems.length) ? widget.portletItems.map(normalizeWidget) : null,
        preview: '',
        type: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment
      };
    };

    var normalizeCollections = function normalizeCollections(collection) {
      var _collection$categorie;

      var normalizedElement = {
        children: collection.portlets.map(normalizeWidget),
        collectionId: collection.path,
        label: collection.title
      };

      if ((_collection$categorie = collection.categories) === null || _collection$categorie === void 0 ? void 0 : _collection$categorie.length) {
        normalizedElement.collections = collection.categories.map(normalizeCollections);
      }

      return normalizedElement;
    };

    var normalizeFragmentEntry = function normalizeFragmentEntry(fragmentEntry, collectionId) {
      if (!fragmentEntry.fragmentEntryKey) {
        return fragmentEntry;
      }

      return {
        data: {
          fragmentEntryKey: fragmentEntry.fragmentEntryKey,
          groupId: fragmentEntry.groupId,
          type: fragmentEntry.type
        },
        icon: fragmentEntry.icon,
        itemId: fragmentEntry.fragmentEntryKey,
        label: fragmentEntry.name,
        preview: collectionId !== BASIC_COMPONENT_COLLECTION ? fragmentEntry.imagePreviewURL : null,
        type: _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment
      };
    };

    function FragmentsSidebar() {
      var fragments = (0, _index.useSelector)(function (state) {
        return state.fragments;
      });
      var widgets = (0, _index.useSelector)(function (state) {
        return state.widgets;
      });

      var _useState = (0, _react.useState)(''),
          _useState2 = _slicedToArray(_useState, 2),
          searchValue = _useState2[0],
          setSearchValue = _useState2[1];

      var tabs = (0, _react.useMemo)(function () {
        return [{
          collections: fragments.map(function (collection) {
            return {
              children: collection.fragmentEntries.map(function (fragmentEntry) {
                return normalizeFragmentEntry(fragmentEntry, collection.fragmentCollectionId);
              }),
              collectionId: collection.fragmentCollectionId,
              label: collection.name
            };
          }),
          label: Liferay.Language.get('fragments')
        }, {
          collections: widgets.map(function (collection) {
            return normalizeCollections(collection);
          }),
          label: Liferay.Language.get('widgets')
        }];
      }, [fragments, widgets]);
      var filteredTabs = (0, _react.useMemo)(function () {
        return searchValue ? tabs.map(function (tab) {
          return _objectSpread(_objectSpread({}, tab), {}, {
            collections: collectionFilter(tab.collections, searchValue)
          });
        }).filter(function (item) {
          return item.collections.length;
        }) : tabs;
      }, [tabs, searchValue]);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_SidebarPanelHeader.default, null, Liferay.Language.get('fragments-and-widgets')), /*#__PURE__*/_react.default.createElement(_SidebarPanelContent.default, {
          className: "page-editor__sidebar__fragments-widgets-panel"
        }, /*#__PURE__*/_react.default.createElement(_SearchForm.default, {
          onChange: setSearchValue
        }), searchValue ? /*#__PURE__*/_react.default.createElement(_SearchResultsPanel.default, {
          filteredTabs: filteredTabs
        }) : /*#__PURE__*/_react.default.createElement(_TabsPanel.default, {
          tabs: tabs
        })))
      );
    }
    //# sourceMappingURL=FragmentsSidebar.js.map
  }
});
//# sourceMappingURL=FragmentsSidebar.js.map