Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/fragments-widgets/components/TabCollection", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../common/components/Collapse', './TabItem'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = TabCollection;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _Collapse = _interopRequireDefault(require("../../../common/components/Collapse"));

    var _TabItem = _interopRequireDefault(require("./TabItem"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    function TabCollection(_ref) {
      var collection = _ref.collection,
          isSearchResult = _ref.isSearchResult,
          open = _ref.open;
      return (/*#__PURE__*/_react.default.createElement(_Collapse.default, {
          key: collection.collectionId,
          label: collection.label,
          open: isSearchResult || open
        }, collection.collections && collection.collections.map(function (collection, index) {
          return (/*#__PURE__*/_react.default.createElement(TabCollection, {
              collection: collection,
              isSearchResult: isSearchResult,
              key: index
            })
          );
        }), /*#__PURE__*/_react.default.createElement("ul", {
          className: "list-unstyled"
        }, collection.children.map(function (item) {
          var _item$portletItems;

          return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
              key: item.itemId
            }, /*#__PURE__*/_react.default.createElement(_TabItem.default, {
              item: item,
              key: item.itemId
            }), ((_item$portletItems = item.portletItems) === null || _item$portletItems === void 0 ? void 0 : _item$portletItems.length) && /*#__PURE__*/_react.default.createElement(TabPortletItems, {
              item: item
            }))
          );
        })))
      );
    }

    TabCollection.proptypes = {
      collection: _propTypes.default.shape({
        children: _propTypes.default.array,
        collectionId: _propTypes.default.string,
        label: _propTypes.default.string
      }).isRequired,
      isSearchResult: _propTypes.default.bool,
      open: _propTypes.default.bool
    };

    var TabPortletItems = function TabPortletItems(_ref2) {
      var item = _ref2.item;
      return (/*#__PURE__*/_react.default.createElement("ul", {
          className: "list-unstyled"
        }, item.portletItems.map(function (portlet, index) {
          return (/*#__PURE__*/_react.default.createElement(_TabItem.default, {
              item: portlet,
              key: index
            })
          );
        }))
      );
    };

    TabPortletItems.proptypes = {
      data: _propTypes.default.shape({
        instanceable: _propTypes.default.bool,
        portletId: _propTypes.default.string,
        portletItemId: _propTypes.default.string,
        used: _propTypes.default.bool
      }).isRequired,
      disabled: _propTypes.default.bool,
      icon: _propTypes.default.string,
      itemId: _propTypes.default.string,
      label: _propTypes.default.string,
      portletItems: _propTypes.default.array,
      preview: _propTypes.default.string,
      type: _propTypes.default.string
    };
    //# sourceMappingURL=TabCollection.js.map
  }
});
//# sourceMappingURL=TabCollection.js.map