Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/page-structure/components/StructureTree", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/alert', 'frontend-js-components-web', 'frontend-js-react-web$react', '../../../app/components/Controls', '../../../app/components/layout-data-items/hasDropZoneChild', '../../../app/config/constants/backgroundImageFragmentEntryProcessor', '../../../app/config/constants/editableFragmentEntryProcessor', '../../../app/config/constants/editableTypes', '../../../app/config/constants/itemTypes', '../../../app/config/constants/layoutDataItemTypes', '../../../app/config/constants/layoutTypes', '../../../app/config/index', '../../../app/selectors/selectCanUpdateEditables', '../../../app/selectors/selectCanUpdateItemConfiguration', '../../../app/store/index', '../../../app/utils/dragAndDrop/useDragAndDrop', '../../../app/utils/getLayoutDataItemLabel', './PageStructureSidebarSection', './StructureTreeNode'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = PageStructureSidebar;

    var _alert = _interopRequireDefault(require("@frontend-taglib-clay$clayui/alert"));

    var _frontendJsComponentsWeb = require("frontend-js-components-web");

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _Controls = require("../../../app/components/Controls");

    var _hasDropZoneChild = _interopRequireDefault(require("../../../app/components/layout-data-items/hasDropZoneChild"));

    var _backgroundImageFragmentEntryProcessor = require("../../../app/config/constants/backgroundImageFragmentEntryProcessor");

    var _editableFragmentEntryProcessor = require("../../../app/config/constants/editableFragmentEntryProcessor");

    var _editableTypes = require("../../../app/config/constants/editableTypes");

    var _itemTypes = require("../../../app/config/constants/itemTypes");

    var _layoutDataItemTypes = require("../../../app/config/constants/layoutDataItemTypes");

    var _layoutTypes = require("../../../app/config/constants/layoutTypes");

    var _index = require("../../../app/config/index");

    var _selectCanUpdateEditables = _interopRequireDefault(require("../../../app/selectors/selectCanUpdateEditables"));

    var _selectCanUpdateItemConfiguration = _interopRequireDefault(require("../../../app/selectors/selectCanUpdateItemConfiguration"));

    var _index2 = require("../../../app/store/index");

    var _useDragAndDrop = require("../../../app/utils/dragAndDrop/useDragAndDrop");

    var _getLayoutDataItemLabel = _interopRequireDefault(require("../../../app/utils/getLayoutDataItemLabel"));

    var _PageStructureSidebarSection = _interopRequireDefault(require("./PageStructureSidebarSection"));

    var _StructureTreeNode = _interopRequireDefault(require("./StructureTreeNode"));

    var _EDITABLE_TYPE_ICONS, _LAYOUT_DATA_ITEM_TYP;

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _toConsumableArray(arr) {
      return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
    }

    function _nonIterableSpread() {
      throw new TypeError("Invalid attempt to spread non-iterable instance");
    }

    function _iterableToArray(iter) {
      if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
    }

    function _arrayWithoutHoles(arr) {
      if (Array.isArray(arr)) {
        for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) {
          arr2[i] = arr[i];
        }return arr2;
      }
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var EDITABLE_TYPE_ICONS = (_EDITABLE_TYPE_ICONS = {}, _defineProperty(_EDITABLE_TYPE_ICONS, _editableTypes.EDITABLE_TYPES.backgroundImage, 'picture'), _defineProperty(_EDITABLE_TYPE_ICONS, _editableTypes.EDITABLE_TYPES.html, 'code'), _defineProperty(_EDITABLE_TYPE_ICONS, _editableTypes.EDITABLE_TYPES.image, 'picture'), _defineProperty(_EDITABLE_TYPE_ICONS, _editableTypes.EDITABLE_TYPES.link, 'link'), _defineProperty(_EDITABLE_TYPE_ICONS, _editableTypes.EDITABLE_TYPES['rich-text'], 'text-editor'), _defineProperty(_EDITABLE_TYPE_ICONS, _editableTypes.EDITABLE_TYPES.text, 'text'), _EDITABLE_TYPE_ICONS);
    var LAYOUT_DATA_ITEM_TYPE_ICONS = (_LAYOUT_DATA_ITEM_TYP = {}, _defineProperty(_LAYOUT_DATA_ITEM_TYP, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection, 'list'), _defineProperty(_LAYOUT_DATA_ITEM_TYP, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem, 'document'), _defineProperty(_LAYOUT_DATA_ITEM_TYP, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container, 'container'), _defineProperty(_LAYOUT_DATA_ITEM_TYP, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone, 'box-container'), _defineProperty(_LAYOUT_DATA_ITEM_TYP, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment, 'code'), _defineProperty(_LAYOUT_DATA_ITEM_TYP, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragmentDropZone, 'box-container'), _defineProperty(_LAYOUT_DATA_ITEM_TYP, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.root, 'page'), _defineProperty(_LAYOUT_DATA_ITEM_TYP, _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.row, 'table'), _LAYOUT_DATA_ITEM_TYP);

    function PageStructureSidebar() {
      var activeItemId = (0, _Controls.useActiveItemId)();
      var canUpdateEditables = (0, _index2.useSelector)(_selectCanUpdateEditables.default);
      var canUpdateItemConfiguration = (0, _index2.useSelector)(_selectCanUpdateItemConfiguration.default);
      var fragmentEntryLinks = (0, _index2.useSelector)(function (state) {
        return state.fragmentEntryLinks;
      });
      var layoutData = (0, _index2.useSelector)(function (state) {
        return state.layoutData;
      });
      var masterLayoutData = (0, _index2.useSelector)(function (state) {
        var _state$masterLayout;

        return (_state$masterLayout = state.masterLayout) === null || _state$masterLayout === void 0 ? void 0 : _state$masterLayout.masterLayoutData;
      });

      var _useState = (0, _react.useState)(null),
          _useState2 = _slicedToArray(_useState, 2),
          dragAndDropHoveredItemId = _useState2[0],
          setDragAndDropHoveredItemId = _useState2[1];

      var isMasterPage = _index.config.layoutType === _layoutTypes.LAYOUT_TYPES.master;
      var data = masterLayoutData || layoutData;
      var onHoverNode = (0, _react.useCallback)(function (itemId) {
        setDragAndDropHoveredItemId(itemId);
      }, []);
      var nodes = (0, _react.useMemo)(function () {
        return visit(data.items[data.rootItems.main], data.items, {
          activeItemId: activeItemId,
          canUpdateEditables: canUpdateEditables,
          canUpdateItemConfiguration: canUpdateItemConfiguration,
          dragAndDropHoveredItemId: dragAndDropHoveredItemId,
          fragmentEntryLinks: fragmentEntryLinks,
          isMasterPage: isMasterPage,
          layoutData: layoutData,
          masterLayoutData: masterLayoutData,
          onHoverNode: onHoverNode
        }).children;
      }, [activeItemId, canUpdateEditables, canUpdateItemConfiguration, data.items, data.rootItems.main, dragAndDropHoveredItemId, fragmentEntryLinks, isMasterPage, layoutData, masterLayoutData, onHoverNode]);
      return (/*#__PURE__*/_react.default.createElement(_PageStructureSidebarSection.default, null, /*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__page-structure__structure-tree"
        }, !nodes.length && /*#__PURE__*/_react.default.createElement(_alert.default, {
          displayType: "info",
          title: Liferay.Language.get('info')
        }, Liferay.Language.get('there-is-no-content-on-this-page')), /*#__PURE__*/_react.default.createElement(_useDragAndDrop.DragAndDropContextProvider, null, /*#__PURE__*/_react.default.createElement(_frontendJsComponentsWeb.Treeview, {
          NodeComponent: _StructureTreeNode.default,
          nodes: nodes,
          selectedNodeIds: [activeItemId]
        }))))
      );
    }

    function isRemovable(item, layoutData) {
      if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone || item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column || item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem) {
        return false;
      }

      return !(0, _hasDropZoneChild.default)(item, layoutData);
    }

    function visit(item, items, _ref) {
      var activeItemId = _ref.activeItemId,
          canUpdateEditables = _ref.canUpdateEditables,
          canUpdateItemConfiguration = _ref.canUpdateItemConfiguration,
          dragAndDropHoveredItemId = _ref.dragAndDropHoveredItemId,
          fragmentEntryLinks = _ref.fragmentEntryLinks,
          isMasterPage = _ref.isMasterPage,
          layoutData = _ref.layoutData,
          masterLayoutData = _ref.masterLayoutData,
          onHoverNode = _ref.onHoverNode;
      var children = [];
      var itemInMasterLayout = masterLayoutData && Object.keys(masterLayoutData.items).includes(item.itemId);
      var icon = LAYOUT_DATA_ITEM_TYPE_ICONS[item.type];

      if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragment) {
        var fragmentEntryLink = fragmentEntryLinks[item.config.fragmentEntryLinkId];
        icon = fragmentEntryLink.icon || icon;
        var editables = _objectSpread(_objectSpread({}, fragmentEntryLink.editableValues[_editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR]), fragmentEntryLink.editableValues[_backgroundImageFragmentEntryProcessor.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR]) || {};
        var editableTypes = fragmentEntryLink.editableTypes;
        Object.keys(editables).forEach(function (editableId) {
          var childId = "".concat(item.config.fragmentEntryLinkId, "-").concat(editableId);
          var type = editableTypes[editableId] || _editableTypes.EDITABLE_TYPES.backgroundImage;
          children.push({
            activable: canUpdateEditables,
            children: [],
            disabled: !isMasterPage && itemInMasterLayout,
            dragAndDropHoveredItemId: dragAndDropHoveredItemId,
            draggable: false,
            expanded: childId === activeItemId,
            icon: EDITABLE_TYPE_ICONS[type],
            id: childId,
            itemType: _itemTypes.ITEM_TYPES.editable,
            name: editableId,
            onHoverNode: onHoverNode,
            parentId: item.parentId,
            removable: false
          });
        });
        children.push.apply(children, _toConsumableArray(item.children.map(function (childItemId) {
          return _objectSpread(_objectSpread({}, visit(items[childItemId], items, {
            activeItemId: activeItemId,
            canUpdateEditables: canUpdateEditables,
            canUpdateItemConfiguration: canUpdateItemConfiguration,
            dragAndDropHoveredItemId: dragAndDropHoveredItemId,
            fragmentEntryLinks: fragmentEntryLinks,
            isMasterPage: isMasterPage,
            layoutData: layoutData,
            masterLayoutData: masterLayoutData,
            onHoverNode: onHoverNode
          })), {}, {
            name: Liferay.Language.get('drop-zone'),
            removable: false
          });
        })));
      } else {
        item.children.forEach(function (childId) {
          var childItem = items[childId];

          if (item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collection && !item.config.collection) {
            return;
          }

          if (!isMasterPage && childItem.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.dropZone) {
            var dropZoneChildren = visit(layoutData.items[layoutData.rootItems.main], layoutData.items, {
              activeItemId: activeItemId,
              canUpdateEditables: canUpdateEditables,
              canUpdateItemConfiguration: canUpdateItemConfiguration,
              dragAndDropHoveredItemId: dragAndDropHoveredItemId,
              fragmentEntryLinks: fragmentEntryLinks,
              isMasterPage: isMasterPage,
              layoutData: layoutData,
              masterLayoutData: masterLayoutData,
              onHoverNode: onHoverNode
            }).children;
            children.push.apply(children, _toConsumableArray(dropZoneChildren));
          } else {
            var child = visit(childItem, items, {
              activeItemId: activeItemId,
              canUpdateEditables: canUpdateEditables,
              canUpdateItemConfiguration: canUpdateItemConfiguration,
              dragAndDropHoveredItemId: dragAndDropHoveredItemId,
              fragmentEntryLinks: fragmentEntryLinks,
              isMasterPage: isMasterPage,
              layoutData: layoutData,
              masterLayoutData: masterLayoutData,
              onHoverNode: onHoverNode
            });
            children.push(child);
          }
        });
      }

      return {
        activable: item.type !== _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.column && item.type !== _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.collectionItem && item.type !== _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.fragmentDropZone && canUpdateItemConfiguration,
        children: children,
        disabled: !isMasterPage && itemInMasterLayout,
        draggable: true,
        expanded: item.itemId === activeItemId || dragAndDropHoveredItemId === item.itemId,
        icon: icon,
        id: item.itemId,
        itemType: _itemTypes.ITEM_TYPES.layoutDataItem,
        name: (0, _getLayoutDataItemLabel.default)(item, fragmentEntryLinks),
        onHoverNode: onHoverNode,
        parentItemId: item.parentId,
        removable: !itemInMasterLayout && isRemovable(item, layoutData),
        type: item.type
      };
    }
    //# sourceMappingURL=StructureTree.js.map
  }
});
//# sourceMappingURL=StructureTree.js.map