Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/page-structure/components/item-configuration-panels/CollectionGeneralPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$react', '../../../../app/config/index', '../../../../app/selectors/selectSegmentsExperienceId', '../../../../app/services/InfoItemService', '../../../../app/store/index', '../../../../app/thunks/updateItemConfig', '../../../../app/utils/useId', '../../../../common/components/CollectionSelector'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.CollectionGeneralPanel = void 0;

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _index = require("../../../../app/config/index");

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../../../../app/selectors/selectSegmentsExperienceId"));

    var _InfoItemService = _interopRequireDefault(require("../../../../app/services/InfoItemService"));

    var _index2 = require("../../../../app/store/index");

    var _updateItemConfig = _interopRequireDefault(require("../../../../app/thunks/updateItemConfig"));

    var _useId = require("../../../../app/utils/useId");

    var _CollectionSelector = _interopRequireDefault(require("../../../../common/components/CollectionSelector"));

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    var LAYOUT_OPTIONS = [{
      label: Liferay.Language.get('full-width'),
      value: '1'
    }, {
      label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 2),
      value: '2'
    }, {
      label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 3),
      value: '3'
    }, {
      label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 4),
      value: '4'
    }, {
      label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 5),
      value: '5'
    }, {
      label: Liferay.Util.sub(Liferay.Language.get('x-columns'), 6),
      value: '6'
    }];
    var LIST_STYLE_GRID = '';
    var DEFAULT_LIST_STYLE = {
      label: Liferay.Language.get('grid'),
      value: LIST_STYLE_GRID
    };

    var CollectionGeneralPanel = function CollectionGeneralPanel(_ref) {
      var item = _ref.item;
      var collectionLayoutId = (0, _useId.useId)();
      var collectionListItemStyleId = (0, _useId.useId)();
      var collectionNumberOfItemsId = (0, _useId.useId)();
      var dispatch = (0, _index2.useDispatch)();
      var listStyleId = (0, _useId.useId)();
      var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId.default);

      var handleConfigurationChanged = function handleConfigurationChanged(itemConfig) {
        dispatch((0, _updateItemConfig.default)({
          itemConfig: itemConfig,
          itemId: item.itemId,
          segmentsExperienceId: segmentsExperienceId
        }));
      };

      var _useState = (0, _react.useState)([]),
          _useState2 = _slicedToArray(_useState, 2),
          availableListItemStyles = _useState2[0],
          setAvailableListItemStyles = _useState2[1];

      var _useState3 = (0, _react.useState)([DEFAULT_LIST_STYLE]),
          _useState4 = _slicedToArray(_useState3, 2),
          availableListStyles = _useState4[0],
          setAvailableListStyles = _useState4[1];

      var collectionItemType = item.config.collection ? item.config.collection.itemType : null;
      (0, _react.useEffect)(function () {
        if (collectionItemType) {
          _InfoItemService.default.getAvailableListRenderers({
            className: collectionItemType
          }).then(function (response) {
            setAvailableListStyles([DEFAULT_LIST_STYLE, {
              label: Liferay.Language.get('templates'),
              options: response,
              type: 'group'
            }]);
          }).catch(function () {
            setAvailableListStyles([DEFAULT_LIST_STYLE]);
          });
        }
      }, [collectionItemType]);
      (0, _react.useEffect)(function () {
        if (item.config.collection, item.config.listStyle && item.config.listStyle !== LIST_STYLE_GRID) {
          _InfoItemService.default.getAvailableListItemRenderers({
            itemSubtype: item.config.collection.itemSubtype,
            itemType: item.config.collection.itemType,
            listStyle: item.config.listStyle
          }).then(function (response) {
            setAvailableListItemStyles(response);
          }).catch(function () {
            setAvailableListItemStyles([]);
          });
        }
      }, [item.config.collection, item.config.listStyle]);
      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_form.default.Group, {
          small: true
        }, /*#__PURE__*/_react.default.createElement(_CollectionSelector.default, {
          collectionTitle: (item.config.collection || {}).title || '',
          itemSelectorURL: _index.config.collectionSelectorURL,
          label: Liferay.Language.get('collection'),
          onCollectionSelect: function onCollectionSelect(collection) {
            return handleConfigurationChanged({
              collection: collection,
              listItemStyle: null,
              listStyle: LIST_STYLE_GRID,
              templateKey: null
            });
          }
        })), item.config.collection && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_form.default.Group, {
          small: true
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: listStyleId
        }, Liferay.Language.get('list-style')), /*#__PURE__*/_react.default.createElement(_form.ClaySelectWithOption, {
          "aria-label": Liferay.Language.get('list-style'),
          id: listStyleId,
          onChange: function onChange(_ref2) {
            var value = _ref2.target.value;
            return handleConfigurationChanged({
              listStyle: value
            });
          },
          options: availableListStyles,
          value: item.config.listStyle
        })), item.config.listStyle === LIST_STYLE_GRID && /*#__PURE__*/_react.default.createElement(_form.default.Group, {
          small: true
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: collectionLayoutId
        }, Liferay.Language.get('layout')), /*#__PURE__*/_react.default.createElement(_form.ClaySelectWithOption, {
          "aria-label": Liferay.Language.get('layout'),
          id: collectionLayoutId,
          onChange: function onChange(_ref3) {
            var value = _ref3.target.value;
            return handleConfigurationChanged({
              numberOfColumns: value
            });
          },
          options: LAYOUT_OPTIONS,
          value: item.config.numberOfColumns
        })), item.config.listStyle !== LIST_STYLE_GRID && availableListItemStyles.length > 0 && /*#__PURE__*/_react.default.createElement(_form.default.Group, {
          small: true
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: collectionListItemStyleId
        }, Liferay.Language.get('list-item-style')), /*#__PURE__*/_react.default.createElement(_form.ClaySelect, {
          "aria-label": Liferay.Language.get('list-item-style'),
          id: collectionListItemStyleId,
          onChange: function onChange(_ref4) {
            var target = _ref4.target;
            return handleConfigurationChanged({
              listItemStyle: target.options[target.selectedIndex].dataset.key,
              templateKey: target.options[target.selectedIndex].dataset.templateKey
            });
          }
        }, availableListItemStyles.map(function (listItemStyle) {
          if (listItemStyle.templates) {
            return (/*#__PURE__*/_react.default.createElement(_form.ClaySelect.OptGroup, {
                key: listItemStyle.label,
                label: listItemStyle.label
              }, listItemStyle.templates.map(function (template) {
                return (/*#__PURE__*/_react.default.createElement(_form.ClaySelect.Option, {
                    "data-key": template.key,
                    "data-template-key": template.templateKey,
                    key: "".concat(template.key, "_").concat(template.templateKey),
                    label: template.label,
                    selected: item.config.listItemStyle === template.key && (!item.config.templateKey || item.config.templateKey === template.templateKey)
                  })
                );
              }))
            );
          } else {
            return (/*#__PURE__*/_react.default.createElement(_form.ClaySelect.Option, {
                "data-key": listItemStyle.key,
                key: listItemStyle.label,
                label: listItemStyle.label,
                selected: item.config.listItemStyle === listItemStyle.key
              })
            );
          }
        }))), /*#__PURE__*/_react.default.createElement(_form.default.Group, {
          small: true
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: collectionNumberOfItemsId
        }, Liferay.Language.get('max-number-of-items')), /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          id: collectionNumberOfItemsId,
          min: 1,
          onChange: function onChange(_ref5) {
            var value = _ref5.target.value;
            return handleConfigurationChanged({
              numberOfItems: value
            });
          },
          type: "number",
          value: item.config.numberOfItems
        }))))
      );
    };

    exports.CollectionGeneralPanel = CollectionGeneralPanel;
    //# sourceMappingURL=CollectionGeneralPanel.js.map
  }
});
//# sourceMappingURL=CollectionGeneralPanel.js.map