Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/page-structure/components/item-configuration-panels/CommonStyles", ['module', 'exports', 'require', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../../app/config/constants/viewportSizes', '../../../../app/config/index', '../../../../app/selectors/selectSegmentsExperienceId', '../../../../app/store/index', '../../../../app/thunks/updateItemConfig', './FieldSet'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.CommonStyles = void 0;

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _viewportSizes = require("../../../../app/config/constants/viewportSizes");

    var _index = require("../../../../app/config/index");

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../../../../app/selectors/selectSegmentsExperienceId"));

    var _index2 = require("../../../../app/store/index");

    var _updateItemConfig = _interopRequireDefault(require("../../../../app/thunks/updateItemConfig"));

    var _FieldSet = require("./FieldSet");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var CommonStyles = function CommonStyles(_ref) {
      var commonStylesValues = _ref.commonStylesValues,
          item = _ref.item;
      var commonStyles = _index.config.commonStyles;
      var dispatch = (0, _index2.useDispatch)();
      var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId.default);
      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });

      var onCommonStylesValueSelect = function onCommonStylesValueSelect(name, value) {
        var itemConfig = {
          styles: _defineProperty({}, name, value)
        };

        if (selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop) {
          itemConfig = _defineProperty({}, selectedViewportSize, {
            styles: _defineProperty({}, name, value)
          });
        }

        dispatch((0, _updateItemConfig.default)({
          itemConfig: itemConfig,
          itemId: item.itemId,
          segmentsExperienceId: segmentsExperienceId
        }));
      };

      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__row-styles-panel__common-styles"
        }, /*#__PURE__*/_react.default.createElement("h1", {
          className: "sr-only"
        }, Liferay.Language.get('common-styles')), commonStyles.map(function (fieldSet, index) {
          return (/*#__PURE__*/_react.default.createElement(_FieldSet.FieldSet, {
              fields: fieldSet.styles,
              item: item,
              key: index,
              label: fieldSet.label,
              onValueSelect: onCommonStylesValueSelect,
              values: commonStylesValues
            })
          );
        }))
      );
    };

    exports.CommonStyles = CommonStyles;
    //# sourceMappingURL=CommonStyles.js.map
  }
});
//# sourceMappingURL=CommonStyles.js.map