Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/page-structure/components/item-configuration-panels/ContainerStylesPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../../app/components/fragment-configuration-fields/SelectField', '../../../../app/config/constants/viewportSizes', '../../../../app/config/index', '../../../../app/selectors/selectSegmentsExperienceId', '../../../../app/store/index', '../../../../app/thunks/updateItemConfig', '../../../../app/utils/getResponsiveConfig', '../../../../prop-types/index', './CommonStyles'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.ContainerStylesPanel = void 0;

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _SelectField = require("../../../../app/components/fragment-configuration-fields/SelectField");

    var _viewportSizes = require("../../../../app/config/constants/viewportSizes");

    var _index = require("../../../../app/config/index");

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../../../../app/selectors/selectSegmentsExperienceId"));

    var _index2 = require("../../../../app/store/index");

    var _updateItemConfig = _interopRequireDefault(require("../../../../app/thunks/updateItemConfig"));

    var _getResponsiveConfig = require("../../../../app/utils/getResponsiveConfig");

    var _index3 = require("../../../../prop-types/index");

    var _CommonStyles = require("./CommonStyles");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var ContainerStylesPanel = function ContainerStylesPanel(_ref) {
      var item = _ref.item;
      var dispatch = (0, _index2.useDispatch)();
      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var segmentsExperienceId = (0, _index2.useSelector)(_selectSegmentsExperienceId.default);
      var availableViewportSizes = _index.config.availableViewportSizes;
      var containerConfig = (0, _getResponsiveConfig.getResponsiveConfig)(item.config, selectedViewportSize);
      var viewportSize = availableViewportSizes[selectedViewportSize];

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
          className: "page-editor__row-styles-panel__viewport-label"
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          className: "mr-2",
          symbol: viewportSize.icon
        }), viewportSize.label), selectedViewportSize === _viewportSizes.VIEWPORT_SIZES.desktop && /*#__PURE__*/_react.default.createElement("div", {
          className: "page-editor__page-structure__section__custom-styles"
        }, /*#__PURE__*/_react.default.createElement("h1", {
          className: "sr-only"
        }, Liferay.Language.get('custom-styles')), /*#__PURE__*/_react.default.createElement(_SelectField.SelectField, {
          field: {
            label: Liferay.Language.get('container-width'),
            name: 'widthType',
            typeOptions: {
              validValues: [{
                label: Liferay.Language.get('fluid'),
                value: 'fluid'
              }, {
                label: Liferay.Language.get('fixed-width'),
                value: 'fixed'
              }]
            }
          },
          onValueSelect: function onCustomStyleValueSelect(name, value) {
            var itemConfig = _defineProperty({}, name, value);

            dispatch((0, _updateItemConfig.default)({
              itemConfig: itemConfig,
              itemId: item.itemId,
              segmentsExperienceId: segmentsExperienceId
            }));
          },
          value: item.config.widthType
        })), /*#__PURE__*/_react.default.createElement(_CommonStyles.CommonStyles, {
          commonStylesValues: containerConfig.styles,
          item: item
        }))
      );
    };

    exports.ContainerStylesPanel = ContainerStylesPanel;
    //# sourceMappingURL=ContainerStylesPanel.js.map
  }
});
//# sourceMappingURL=ContainerStylesPanel.js.map