Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/page-structure/components/item-configuration-panels/FieldSet", ['module', 'exports', 'require', 'frontend-js-react-web$classnames', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../../app/components/fragment-configuration-fields/index', '../../../../app/config/constants/layoutDataItemTypes', '../../../../app/config/constants/viewportSizes', '../../../../app/store/index', '../../../../prop-types/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.FieldSet = void 0;

    var _classnames = _interopRequireDefault(require("frontend-js-react-web$classnames"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _index = require("../../../../app/components/fragment-configuration-fields/index");

    var _layoutDataItemTypes = require("../../../../app/config/constants/layoutDataItemTypes");

    var _viewportSizes = require("../../../../app/config/constants/viewportSizes");

    var _index2 = require("../../../../app/store/index");

    var _index3 = require("../../../../prop-types/index");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    var DISPLAY_SIZES = {
      small: 'small'
    };

    var fieldIsDisabled = function fieldIsDisabled(item, field) {
      var _item$config;

      return item.type === _layoutDataItemTypes.LAYOUT_DATA_ITEM_TYPES.container && ((_item$config = item.config) === null || _item$config === void 0 ? void 0 : _item$config.widthType) === 'fixed' && (field.name === 'marginRight' || field.name === 'marginLeft');
    };

    var FieldSet = function FieldSet(_ref) {
      var fields = _ref.fields,
          _ref$item = _ref.item,
          item = _ref$item === void 0 ? {} : _ref$item,
          label = _ref.label,
          onValueSelect = _ref.onValueSelect,
          values = _ref.values;
      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var availableFields = selectedViewportSize === _viewportSizes.VIEWPORT_SIZES.desktop ? fields : fields.filter(function (field) {
        return field.responsive;
      });
      return availableFields.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, label && /*#__PURE__*/_react.default.createElement("div", {
        className: "align-items-center d-flex justify-content-between page-editor__sidebar__fieldset-label pt-2"
      }, /*#__PURE__*/_react.default.createElement("p", {
        className: "mb-2 text-uppercase"
      }, label)), /*#__PURE__*/_react.default.createElement("div", {
        className: "page-editor__sidebar__fieldset"
      }, availableFields.map(function (field, index) {
        var FieldComponent = field.type && _index.FRAGMENT_CONFIGURATION_FIELDS[field.type];
        var fieldValue = Object.keys(values).includes(field.name) ? values[field.name] : field.defaultValue;
        var visible = !field.dependencies || field.dependencies.every(function (dependency) {
          return values[dependency.styleName] === dependency.value;
        });
        return visible && /*#__PURE__*/_react.default.createElement("div", {
          className: (0, _classnames.default)('page-editor__sidebar__fieldset__field', {
            'page-editor__sidebar__fieldset__field-small': field.displaySize === DISPLAY_SIZES.small
          }),
          key: index
        }, /*#__PURE__*/_react.default.createElement(FieldComponent, {
          disabled: fieldIsDisabled(item, field),
          field: field,
          onValueSelect: onValueSelect,
          value: fieldValue
        }));
      })));
    };

    exports.FieldSet = FieldSet;
    //# sourceMappingURL=FieldSet.js.map
  }
});
//# sourceMappingURL=FieldSet.js.map