Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/page-structure/components/item-configuration-panels/ImagePropertiesPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$react', '../../../../app/config/constants/backgroundImageFragmentEntryProcessor', '../../../../app/config/constants/editableFragmentEntryProcessor', '../../../../app/config/constants/editableTypes', '../../../../app/config/index', '../../../../app/selectors/selectEditableValueContent', '../../../../app/store/index', '../../../../app/thunks/updateEditableValues', '../../../../app/utils/useId', '../../../../common/components/ImageSelector', '../../../../prop-types/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.ImagePropertiesPanel = ImagePropertiesPanel;

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    var _backgroundImageFragmentEntryProcessor = require("../../../../app/config/constants/backgroundImageFragmentEntryProcessor");

    var _editableFragmentEntryProcessor = require("../../../../app/config/constants/editableFragmentEntryProcessor");

    var _editableTypes = require("../../../../app/config/constants/editableTypes");

    var _index = require("../../../../app/config/index");

    var _selectEditableValueContent = _interopRequireDefault(require("../../../../app/selectors/selectEditableValueContent"));

    var _index2 = require("../../../../app/store/index");

    var _updateEditableValues = _interopRequireDefault(require("../../../../app/thunks/updateEditableValues"));

    var _useId = require("../../../../app/utils/useId");

    var _ImageSelector = require("../../../../common/components/ImageSelector");

    var _index3 = require("../../../../prop-types/index");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function ownKeys(object, enumerableOnly) {
      var keys = Object.keys(object);if (Object.getOwnPropertySymbols) {
        var symbols = Object.getOwnPropertySymbols(object);if (enumerableOnly) symbols = symbols.filter(function (sym) {
          return Object.getOwnPropertyDescriptor(object, sym).enumerable;
        });keys.push.apply(keys, symbols);
      }return keys;
    }

    function _objectSpread(target) {
      for (var i = 1; i < arguments.length; i++) {
        var source = arguments[i] != null ? arguments[i] : {};if (i % 2) {
          ownKeys(Object(source), true).forEach(function (key) {
            _defineProperty(target, key, source[key]);
          });
        } else if (Object.getOwnPropertyDescriptors) {
          Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
        } else {
          ownKeys(Object(source)).forEach(function (key) {
            Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key));
          });
        }
      }return target;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    function _slicedToArray(arr, i) {
      return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
    }

    function _nonIterableRest() {
      throw new TypeError("Invalid attempt to destructure non-iterable instance");
    }

    function _iterableToArrayLimit(arr, i) {
      if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
        return;
      }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
        for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
          _arr.push(_s.value);if (i && _arr.length === i) break;
        }
      } catch (err) {
        _d = true;_e = err;
      } finally {
        try {
          if (!_n && _i["return"] != null) _i["return"]();
        } finally {
          if (_d) throw _e;
        }
      }return _arr;
    }

    function _arrayWithHoles(arr) {
      if (Array.isArray(arr)) return arr;
    }

    function ImagePropertiesPanel(_ref) {
      var _editables$item$paren, _editables$item$paren2;

      var item = _ref.item;
      var editableId = item.editableId,
          fragmentEntryLinkId = item.fragmentEntryLinkId,
          type = item.type;
      var dispatch = (0, _index2.useDispatch)();
      var imageDescriptionId = (0, _useId.useId)();
      var state = (0, _index2.useSelector)(function (state) {
        return state;
      });
      var selectedViewportSize = (0, _index2.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var processorKey = type === _editableTypes.EDITABLE_TYPES.backgroundImage ? _backgroundImageFragmentEntryProcessor.BACKGROUND_IMAGE_FRAGMENT_ENTRY_PROCESSOR : _editableFragmentEntryProcessor.EDITABLE_FRAGMENT_ENTRY_PROCESSOR;
      var editableValues = state.fragmentEntryLinks[fragmentEntryLinkId].editableValues;
      var editableValue = editableValues[processorKey][editableId];
      var editableConfig = editableValue.config || {};

      var _useState = (0, _react.useState)(editableConfig.alt || ''),
          _useState2 = _slicedToArray(_useState, 2),
          imageDescription = _useState2[0],
          setImageDescription = _useState2[1];

      var editables = (0, _index2.useSelector)(function (state) {
        return state.editables;
      });
      var editableElement = editables ? (_editables$item$paren = editables[item.parentId]) === null || _editables$item$paren === void 0 ? void 0 : (_editables$item$paren2 = _editables$item$paren[item.itemId]) === null || _editables$item$paren2 === void 0 ? void 0 : _editables$item$paren2.element : undefined;

      var _useState3 = (0, _react.useState)(null),
          _useState4 = _slicedToArray(_useState3, 2),
          imageSize = _useState4[0],
          setImageSize = _useState4[1];

      (0, _react.useEffect)(function () {
        if (editableElement != null) {
          var setSize = function setSize() {
            if (editableElement.naturalHeight && editableElement.naturalWidth) {
              setImageSize({
                height: editableElement.naturalHeight,
                width: editableElement.naturalWidth
              });
            }
          };

          if (editableElement.complete) {
            setSize();
          } else {
            editableElement.addEventListener('load', setSize);
            return function () {
              return editableElement.removeEventListener('load', setSize);
            };
          }
        }
      }, [editableConfig.naturalHeight, editableElement, selectedViewportSize]);
      (0, _react.useEffect)(function () {
        var editableConfig = editableValue ? editableValue.config || {} : {};
        setImageDescription(function (imageDescription) {
          if (imageDescription !== editableConfig.alt) {
            return editableConfig.alt || '';
          }

          return imageDescription;
        });
      }, [editableValue]);
      var imageUrl = (0, _index2.useSelector)(function (state) {
        var content = (0, _selectEditableValueContent.default)(state, fragmentEntryLinkId, editableId, processorKey);

        if (typeof content === 'string') {
          return content;
        }

        return content === null || content === void 0 ? void 0 : content.url;
      });
      var imageTitle = editableConfig.imageTitle || (imageUrl === editableValue.defaultValue ? '' : imageUrl);

      var updateEditableValues = function updateEditableValues(alt, editableValues, editableId, processorKey) {
        var editableProcessorValues = editableValues[processorKey];
        var editableValue = editableValues[processorKey][editableId];
        var editableConfig = editableValue.config || {};

        var nextEditableValues = _objectSpread(_objectSpread({}, editableValues), {}, _defineProperty({}, processorKey, _objectSpread(_objectSpread({}, editableProcessorValues), {}, _defineProperty({}, editableId, _objectSpread(_objectSpread({}, editableProcessorValues[editableId]), {}, {
          config: _objectSpread(_objectSpread({}, editableConfig), {}, {
            alt: alt
          })
        })))));

        dispatch((0, _updateEditableValues.default)({
          editableValues: nextEditableValues,
          fragmentEntryLinkId: fragmentEntryLinkId,
          segmentsExperienceId: state.segmentsExperienceId
        }));
      };

      var onImageChange = function onImageChange(imageTitle, imageUrl, fileEntryId) {
        var editableValues = state.fragmentEntryLinks[fragmentEntryLinkId].editableValues;
        var editableProcessorValues = editableValues[processorKey];
        var editableValue = editableProcessorValues[editableId];
        var nextEditableValue = {};
        setImageDescription('');

        var nextEditableValueConfig = _objectSpread(_objectSpread({}, editableValue.config), {}, {
          alt: '',
          imageTitle: imageTitle || ''
        });

        var nextEditableValueContent = _index.config.adaptiveMediaEnabled ? {
          fileEntryId: fileEntryId,
          url: imageUrl
        } : imageUrl;
        nextEditableValue = _objectSpread(_objectSpread({}, editableValue), {}, _defineProperty({
          config: nextEditableValueConfig
        }, state.languageId, nextEditableValueContent));

        var nextEditableValues = _objectSpread(_objectSpread({}, editableValues), {}, _defineProperty({}, processorKey, _objectSpread(_objectSpread({}, editableProcessorValues), {}, _defineProperty({}, editableId, _objectSpread({}, nextEditableValue)))));

        dispatch((0, _updateEditableValues.default)({
          editableValues: nextEditableValues,
          fragmentEntryLinkId: fragmentEntryLinkId,
          segmentsExperienceId: state.segmentsExperienceId
        }));
      };

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ImageSelector.ImageSelector, {
          imageTitle: imageTitle,
          label: Liferay.Language.get('image'),
          onClearButtonPressed: function onClearButtonPressed() {
            return onImageChange('', '');
          },
          onImageSelected: function onImageSelected(image) {
            return onImageChange(image.title, image.url, image.fileEntryId);
          }
        }), imageTitle && imageSize && /*#__PURE__*/_react.default.createElement("div", {
          className: "mb-2 small"
        }, /*#__PURE__*/_react.default.createElement("b", null, Liferay.Language.get('resolution'), ":"), /*#__PURE__*/_react.default.createElement("span", {
          className: "ml-2"
        }, imageSize.width, "x", imageSize.height, "px")), type === _editableTypes.EDITABLE_TYPES.image && /*#__PURE__*/_react.default.createElement(_form.default.Group, null, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: imageDescriptionId
        }, Liferay.Language.get('image-description')), /*#__PURE__*/_react.default.createElement(_form.ClayInput, {
          id: imageDescriptionId,
          onBlur: function onBlur() {
            var previousValue = editableConfig.alt || '';

            if (previousValue !== imageDescription) {
              updateEditableValues(imageDescription, editableValues, editableId, processorKey);
            }
          },
          onChange: function onChange(event) {
            setImageDescription(event.target.value);
          },
          sizing: "sm",
          type: "text",
          value: imageDescription || ''
        })))
      );
    }
    //# sourceMappingURL=ImagePropertiesPanel.js.map
  }
});
//# sourceMappingURL=ImagePropertiesPanel.js.map