Liferay.Loader.define("layout-content-page-editor-web@2.0.122/page_editor/plugins/page-structure/components/item-configuration-panels/RowGeneralPanel", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/form', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react', '../../../../app/config/constants/viewportSizes', '../../../../app/selectors/selectSegmentsExperienceId', '../../../../app/store/index', '../../../../app/thunks/updateItemConfig', '../../../../app/thunks/updateRowColumns', '../../../../app/utils/getResponsiveConfig', '../../../../app/utils/useId', '../../../../prop-types/index'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    function _typeof(obj) {
      "@babel/helpers - typeof";
      if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
        _typeof = function _typeof(obj) {
          return typeof obj;
        };
      } else {
        _typeof = function _typeof(obj) {
          return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
        };
      }return _typeof(obj);
    }

    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.RowGeneralPanel = void 0;

    var _form = _interopRequireWildcard(require("@frontend-taglib-clay$clayui/form"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireDefault(require("frontend-js-react-web$react"));

    var _viewportSizes = require("../../../../app/config/constants/viewportSizes");

    var _selectSegmentsExperienceId = _interopRequireDefault(require("../../../../app/selectors/selectSegmentsExperienceId"));

    var _index = require("../../../../app/store/index");

    var _updateItemConfig = _interopRequireDefault(require("../../../../app/thunks/updateItemConfig"));

    var _updateRowColumns = _interopRequireDefault(require("../../../../app/thunks/updateRowColumns"));

    var _getResponsiveConfig = require("../../../../app/utils/getResponsiveConfig");

    var _useId = require("../../../../app/utils/useId");

    var _index2 = require("../../../../prop-types/index");

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _defineProperty(obj, key, value) {
      if (key in obj) {
        Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true });
      } else {
        obj[key] = value;
      }return obj;
    }

    var NUMBER_OF_COLUMNS_OPTIONS = ['1', '2', '3', '4', '5', '6'];
    var ROW_CONFIGURATION_IDENTIFIERS = {
      gutters: 'gutters',
      numberOfColumns: 'numberOfColumns'
    };

    var RowGeneralPanel = function RowGeneralPanel(_ref) {
      var item = _ref.item;
      var dispatch = (0, _index.useDispatch)();
      var segmentsExperienceId = (0, _index.useSelector)(_selectSegmentsExperienceId.default);
      var selectedViewportSize = (0, _index.useSelector)(function (state) {
        return state.selectedViewportSize;
      });
      var rowConfig = (0, _getResponsiveConfig.getResponsiveConfig)(item.config, selectedViewportSize);

      var handleConfigurationValueChanged = function handleConfigurationValueChanged(identifier, value) {
        var itemConfig = _defineProperty({}, identifier, value);

        if (selectedViewportSize !== _viewportSizes.VIEWPORT_SIZES.desktop && identifier !== ROW_CONFIGURATION_IDENTIFIERS.gutters) {
          itemConfig = _defineProperty({}, selectedViewportSize, itemConfig);
        }

        if (identifier === ROW_CONFIGURATION_IDENTIFIERS.numberOfColumns) {
          var currentNumberOfColumns = rowConfig.numberOfColumns;
          var newNumberOfColumns = value;
          var columnsToBeModified = Math.abs(newNumberOfColumns - currentNumberOfColumns);

          if (columnsToBeModified === 0) {
            return;
          }

          if (item && item.itemId) {
            dispatch((0, _updateRowColumns.default)({
              itemId: item.itemId,
              numberOfColumns: newNumberOfColumns,
              segmentsExperienceId: segmentsExperienceId,
              viewportSizeId: selectedViewportSize
            }));
          }

          return;
        }

        dispatch((0, _updateItemConfig.default)({
          itemConfig: itemConfig,
          itemId: item.itemId,
          segmentsExperienceId: segmentsExperienceId
        }));
      };

      return (/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Select, {
          configurationKey: "numberOfColumns",
          handleChange: handleConfigurationValueChanged,
          label: Liferay.Language.get('number-of-modules'),
          options: NUMBER_OF_COLUMNS_OPTIONS.map(function (option) {
            return {
              label: option
            };
          }),
          value: rowConfig.numberOfColumns
        }), rowConfig.numberOfColumns > 1 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_form.ClayCheckbox, {
          checked: rowConfig.gutters,
          label: Liferay.Language.get('show-gutter'),
          onChange: function onChange(_ref2) {
            var checked = _ref2.target.checked;
            return handleConfigurationValueChanged('gutters', checked);
          }
        })))
      );
    };

    exports.RowGeneralPanel = RowGeneralPanel;

    var Select = function Select(_ref3) {
      var configurationKey = _ref3.configurationKey,
          handleChange = _ref3.handleChange,
          label = _ref3.label,
          options = _ref3.options,
          value = _ref3.value;
      var inputId = (0, _useId.useId)();
      return (/*#__PURE__*/_react.default.createElement(_form.default.Group, {
          small: true
        }, /*#__PURE__*/_react.default.createElement("label", {
          htmlFor: inputId
        }, label), /*#__PURE__*/_react.default.createElement(_form.ClaySelectWithOption, {
          id: inputId,
          onChange: function onChange(event) {
            var nextValue = event.target.value;
            handleChange(configurationKey, typeof value === 'string' ? String(nextValue) : Number(nextValue));
          },
          options: options,
          value: String(value)
        }))
      );
    };
    //# sourceMappingURL=RowGeneralPanel.js.map
  }
});
//# sourceMappingURL=RowGeneralPanel.js.map