/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.exportimport.data.handler;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.layout.model.LayoutClassedModelUsage;
import com.liferay.layout.service.LayoutClassedModelUsageLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={LayoutClassedModelUsageStagedModelDataHandler.class, StagedModelDataHandler.class})
public class LayoutClassedModelUsageStagedModelDataHandler
extends BaseStagedModelDataHandler<LayoutClassedModelUsage> {
    public static final String[] CLASS_NAMES = new String[]{LayoutClassedModelUsage.class.getName()};
    private static final Log _log = LogFactoryUtil.getLog(LayoutClassedModelUsageStagedModelDataHandler.class);
    @Reference
    private LayoutClassedModelUsageLocalService _layoutClassedModelUsageLocalService;
    @Reference
    private Portal _portal;
    @Reference(target="(model.class.name=com.liferay.layout.model.LayoutClassedModelUsage)", unbind="-")
    private StagedModelRepository<LayoutClassedModelUsage> _stagedModelRepository;

    public void deleteStagedModel(LayoutClassedModelUsage layoutClassedModelUsage) throws PortalException {
        this._stagedModelRepository.deleteStagedModel((StagedModel)layoutClassedModelUsage);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        this._stagedModelRepository.deleteStagedModel(uuid, groupId, className, extraData);
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, LayoutClassedModelUsage layoutClassedModelUsage) throws Exception {
        Element element = portletDataContext.getExportDataElement((ClassedModel)layoutClassedModelUsage);
        element.addAttribute("layout-classed-model-class-name", this._portal.getClassName(layoutClassedModelUsage.getClassNameId()));
        element.addAttribute("layout-classed-model-container-class-name", this._portal.getClassName(layoutClassedModelUsage.getContainerType()));
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)layoutClassedModelUsage.getClassName());
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (ExportImportThreadLocal.isStagingInProcess() && assetRendererFactory != null && stagingGroupHelper.isStagedPortlet(portletDataContext.getScopeGroupId(), assetRendererFactory.getPortletId())) {
            AssetRenderer assetRenderer;
            block4: {
                assetRenderer = null;
                try {
                    assetRenderer = assetRendererFactory.getAssetRenderer(layoutClassedModelUsage.getClassPK());
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) break block4;
                    _log.debug((Object)portalException, (Throwable)portalException);
                }
            }
            if (assetRenderer != null && assetRenderer.getStatus() == 0) {
                StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)layoutClassedModelUsage, (StagedModel)((StagedModel)assetRenderer.getAssetObject()), (String)"dependency", (String)assetRendererFactory.getPortletId());
            }
        }
        portletDataContext.addClassedModel(element, ExportImportPathUtil.getModelPath((StagedModel)layoutClassedModelUsage), (ClassedModel)layoutClassedModelUsage);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, String uuid, long groupId, long layoutClassedModelUsageId) throws Exception {
        LayoutClassedModelUsage existingLayoutClassedModelUsage = (LayoutClassedModelUsage)this.fetchMissingReference(uuid, groupId);
        if (existingLayoutClassedModelUsage == null) {
            return;
        }
        Map layoutClassedModelUsageids = portletDataContext.getNewPrimaryKeysMap(LayoutClassedModelUsage.class);
        layoutClassedModelUsageids.put(layoutClassedModelUsageId, existingLayoutClassedModelUsage.getLayoutClassedModelUsageId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, LayoutClassedModelUsage layoutClassedModelUsage) throws Exception {
        LayoutClassedModelUsage existingLayoutClassedModelUsage;
        long containerKey;
        LayoutClassedModelUsage importedLayoutClassedModelUsage = (LayoutClassedModelUsage)layoutClassedModelUsage.clone();
        importedLayoutClassedModelUsage.setGroupId(portletDataContext.getScopeGroupId());
        importedLayoutClassedModelUsage.setCompanyId(portletDataContext.getCompanyId());
        Map plids = portletDataContext.getNewPrimaryKeysMap(Layout.class);
        long plid = MapUtil.getLong((Map)plids, (long)layoutClassedModelUsage.getPlid(), (long)layoutClassedModelUsage.getPlid());
        importedLayoutClassedModelUsage.setPlid(plid);
        importedLayoutClassedModelUsage.setClassNameId(this._portal.getClassNameId(layoutClassedModelUsage.getClassName()));
        Map classPKs = portletDataContext.getNewPrimaryKeysMap(layoutClassedModelUsage.getClassName());
        long classPK = MapUtil.getLong((Map)classPKs, (long)layoutClassedModelUsage.getClassPK(), (long)layoutClassedModelUsage.getClassPK());
        importedLayoutClassedModelUsage.setClassPK(classPK);
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)layoutClassedModelUsage);
        long containerTypeClassNameId = this._portal.getClassNameId(element.attributeValue("layout-classed-model-container-class-name"));
        if (containerTypeClassNameId == this._portal.getClassNameId(FragmentEntryLink.class) && (containerKey = GetterUtil.getLong((String)layoutClassedModelUsage.getContainerKey())) != 0L) {
            Map fragmentLinkEntryIds = portletDataContext.getNewPrimaryKeysMap(FragmentEntryLink.class.getName());
            containerKey = MapUtil.getLong((Map)fragmentLinkEntryIds, (long)containerKey, (long)containerKey);
            importedLayoutClassedModelUsage.setContainerKey(String.valueOf(containerKey));
            importedLayoutClassedModelUsage.setContainerType(this._portal.getClassNameId(FragmentEntryLink.class));
        }
        if ((existingLayoutClassedModelUsage = this._layoutClassedModelUsageLocalService.fetchLayoutClassedModelUsage(this._portal.getClassNameId(element.attributeValue("layout-classed-model-class-name")), classPK, importedLayoutClassedModelUsage.getContainerKey(), containerTypeClassNameId, plid)) == null) {
            existingLayoutClassedModelUsage = (LayoutClassedModelUsage)this._stagedModelRepository.fetchStagedModelByUuidAndGroupId(layoutClassedModelUsage.getUuid(), portletDataContext.getScopeGroupId());
        }
        if (existingLayoutClassedModelUsage == null || !portletDataContext.isDataStrategyMirror()) {
            importedLayoutClassedModelUsage = (LayoutClassedModelUsage)this._stagedModelRepository.addStagedModel(portletDataContext, (StagedModel)importedLayoutClassedModelUsage);
        } else {
            importedLayoutClassedModelUsage.setMvccVersion(existingLayoutClassedModelUsage.getMvccVersion());
            importedLayoutClassedModelUsage.setLayoutClassedModelUsageId(existingLayoutClassedModelUsage.getLayoutClassedModelUsageId());
            importedLayoutClassedModelUsage = (LayoutClassedModelUsage)this._stagedModelRepository.updateStagedModel(portletDataContext, (StagedModel)importedLayoutClassedModelUsage);
        }
        portletDataContext.importClassedModel((ClassedModel)layoutClassedModelUsage, (ClassedModel)importedLayoutClassedModelUsage);
    }

    protected StagedModelRepository<LayoutClassedModelUsage> getStagedModelRepository() {
        return this._stagedModelRepository;
    }
}

