/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.osgi.commands;

import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.serializer.LayoutStructureItemJSONSerializer;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.LayoutLocalService;
import org.apache.felix.service.command.Descriptor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"osgi.command.function=exportAsJSON", "osgi.command.scope=layout"}, service={LayoutOSGiCommands.class})
public class LayoutOSGiCommands {
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;
    @Reference
    private LayoutStructureItemJSONSerializer _layoutStructureItemJSONSerializer;

    @Descriptor(value="Get page definition JSON for a given layout by its PLID")
    public String exportAsJSON(long plid) throws PortalException {
        Layout layout = this._layoutLocalService.fetchLayout(plid);
        if (layout == null) {
            return "Layout with PLID " + plid + " does not exist";
        }
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), plid);
        if (layoutPageTemplateStructure == null) {
            return "Layout with PLID " + plid + " does not have a layout page template structure";
        }
        long segmentsExperienceId = 0L;
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(segmentsExperienceId));
        return this._layoutStructureItemJSONSerializer.toJSONString(layout, layoutStructure.getMainItemId(), false, false, segmentsExperienceId);
    }
}

