/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.search.spi.model.index.contributor;

import com.liferay.layout.internal.search.util.LayoutCrawler;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalService;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.portal.kernel.model.Layout"}, service={ModelDocumentContributor.class})
public class LayoutModelDocumentContributor
implements ModelDocumentContributor<Layout> {
    public static final String CLASS_NAME = Layout.class.getName();
    private static final String _WRAPPER_ELEMENT = "id=\"wrapper\">";
    @Reference
    private Html _html;
    @Reference
    private LayoutCrawler _layoutCrawler;
    @Reference
    private LayoutPageTemplateStructureLocalService _layoutPageTemplateStructureLocalService;

    public void contribute(Document document, Layout layout) {
        if (layout.isSystem() || layout.getStatus() != 0) {
            return;
        }
        document.addText("defaultLanguageId", layout.getDefaultLanguageId());
        document.addLocalizedText("name", layout.getNameMap());
        document.addText("privateLayout", String.valueOf(layout.isPrivateLayout()));
        document.addKeyword("status", this._getStatus(layout));
        document.addText("type", layout.getType());
        LayoutPageTemplateStructure layoutPageTemplateStructure = this._layoutPageTemplateStructureLocalService.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid());
        for (String languageId : layout.getAvailableLanguageIds()) {
            Locale locale = LocaleUtil.fromLanguageId((String)languageId);
            document.addText(Field.getLocalizedName((Locale)locale, (String)"title"), layout.getName(locale));
        }
        if (layoutPageTemplateStructure == null) {
            return;
        }
        Set locales = LanguageUtil.getAvailableLocales((long)layout.getGroupId());
        for (Locale locale : locales) {
            String content = this._html.stripHtml(this._getWrapper(this._layoutCrawler.getLayoutContent(layout, locale)));
            if (Validator.isNull((String)content)) continue;
            document.addText(Field.getLocalizedName((Locale)locale, (String)"content"), content);
        }
    }

    private int _getStatus(Layout layout) {
        if (!layout.isTypeContent()) {
            return 0;
        }
        Layout draftLayout = layout.fetchDraftLayout();
        boolean published = false;
        if (draftLayout != null) {
            published = GetterUtil.getBoolean((String)draftLayout.getTypeSettingsProperty("published"));
        }
        if (published) {
            return 0;
        }
        return 2;
    }

    private String _getWrapper(String layoutContent) {
        int wrapperIndex = layoutContent.indexOf(_WRAPPER_ELEMENT);
        if (wrapperIndex == -1) {
            return layoutContent;
        }
        return layoutContent.substring(wrapperIndex + _WRAPPER_ELEMENT.length());
    }
}

