/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.internal.workflow;

import com.liferay.layout.internal.configuration.LayoutWorkflowHandlerConfiguration;
import com.liferay.layout.util.LayoutCopyHelper;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.WorkflowDefinitionLink;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.workflow.BaseWorkflowHandler;
import com.liferay.portal.kernel.workflow.WorkflowHandler;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.layout.internal.configuration.LayoutWorkflowHandlerConfiguration"}, property={"model.class.name=com.liferay.portal.kernel.model.Layout"}, service={WorkflowHandler.class})
public class LayoutWorkflowHandler
extends BaseWorkflowHandler<Layout> {
    private volatile LayoutWorkflowHandlerConfiguration _layoutConverterConfiguration;
    @Reference
    private LayoutCopyHelper _layoutCopyHelper;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;
    private final ResourceBundleLoader _resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)"com.liferay.layout.impl");

    public String getClassName() {
        return Layout.class.getName();
    }

    public String getType(Locale locale) {
        ResourceBundle resourceBundle = this._resourceBundleLoader.loadResourceBundle(locale);
        return LanguageUtil.get((ResourceBundle)resourceBundle, (String)"content-page");
    }

    public WorkflowDefinitionLink getWorkflowDefinitionLink(long companyId, long groupId, long classPK) throws PortalException {
        Layout layout = this._layoutLocalService.getLayout(classPK);
        if (layout.isHidden() || layout.isSystem() || !layout.isTypeContent()) {
            return null;
        }
        return super.getWorkflowDefinitionLink(companyId, groupId, classPK);
    }

    public boolean isVisible() {
        return this._layoutConverterConfiguration.enabled();
    }

    public Layout updateStatus(int status, Map<String, Serializable> workflowContext) throws PortalException {
        long userId = GetterUtil.getLong((String)((String)((Object)workflowContext.get("userId"))));
        long classPK = GetterUtil.getLong((String)((String)((Object)workflowContext.get("entryClassPK"))));
        Layout layout = this._layoutLocalService.getLayout(classPK);
        if (layout.isDenied() && status == 1) {
            return layout;
        }
        ServiceContext serviceContext = (ServiceContext)workflowContext.get("serviceContext");
        if (status != 0) {
            return this._layoutLocalService.updateStatus(userId, classPK, status, serviceContext);
        }
        Layout draftLayout = layout.fetchDraftLayout();
        try {
            this._layoutCopyHelper.copyLayout(draftLayout, layout);
        }
        catch (Exception exception) {
            throw new PortalException((Throwable)exception);
        }
        UnicodeProperties typeSettingsUnicodeProperties = draftLayout.getTypeSettingsProperties();
        typeSettingsUnicodeProperties.setProperty("published", "true");
        draftLayout = this._layoutLocalService.updateLayout(draftLayout.getGroupId(), draftLayout.isPrivateLayout(), draftLayout.getLayoutId(), typeSettingsUnicodeProperties.toString());
        draftLayout.setStatus(0);
        this._layoutLocalService.updateLayout(draftLayout);
        return this._layoutLocalService.updateStatus(userId, classPK, status, serviceContext);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._layoutConverterConfiguration = (LayoutWorkflowHandlerConfiguration)ConfigurableUtil.createConfigurable(LayoutWorkflowHandlerConfiguration.class, properties);
    }
}

