/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.util;

import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalServiceUtil;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.util.Validator;

public class LayoutStructureUtil {
    private static final Log _log = LogFactoryUtil.getLog(LayoutStructureUtil.class);

    public static LayoutStructure getLayoutStructure(long plid, long segmentsExperienceId) {
        try {
            Layout layout = LayoutStructureUtil._getLayout(plid);
            LayoutPageTemplateStructure layoutPageTemplateStructure = LayoutPageTemplateStructureLocalServiceUtil.fetchLayoutPageTemplateStructure(layout.getGroupId(), layout.getPlid(), true);
            String data = layoutPageTemplateStructure.getData(segmentsExperienceId);
            if (Validator.isNull((String)data)) {
                return null;
            }
            String masterLayoutData = LayoutStructureUtil._getMasterLayoutData(layout.getMasterLayoutPlid());
            if (Validator.isNull((String)masterLayoutData)) {
                return LayoutStructure.of((String)data);
            }
            return LayoutStructureUtil._mergeLayoutStructure(data, masterLayoutData);
        }
        catch (Exception exception) {
            _log.error((Object)"Unable to get layout structure", (Throwable)exception);
            return null;
        }
    }

    private static Layout _getLayout(long plid) {
        Layout layout = LayoutLocalServiceUtil.fetchLayout((long)plid);
        if (layout instanceof VirtualLayout) {
            VirtualLayout virtualLayout = (VirtualLayout)layout;
            layout = virtualLayout.getSourceLayout();
        }
        return layout;
    }

    private static String _getMasterLayoutData(long masterLayoutPlid) {
        LayoutPageTemplateEntry masterLayoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid(masterLayoutPlid);
        if (masterLayoutPageTemplateEntry == null) {
            return null;
        }
        LayoutPageTemplateStructure masterLayoutPageTemplateStructure = LayoutPageTemplateStructureLocalServiceUtil.fetchLayoutPageTemplateStructure(masterLayoutPageTemplateEntry.getGroupId(), masterLayoutPageTemplateEntry.getPlid());
        if (masterLayoutPageTemplateStructure == null) {
            return null;
        }
        return masterLayoutPageTemplateStructure.getDefaultSegmentsExperienceData();
    }

    private static LayoutStructure _mergeLayoutStructure(String data, String masterLayoutData) {
        LayoutStructure masterLayoutStructure = LayoutStructure.of((String)masterLayoutData);
        LayoutStructure layoutStructure = LayoutStructure.of((String)data);
        for (LayoutStructureItem layoutStructureItem : layoutStructure.getLayoutStructureItems()) {
            masterLayoutStructure.addLayoutStructureItem(layoutStructureItem);
        }
        DropZoneLayoutStructureItem dropZoneLayoutStructureItem = (DropZoneLayoutStructureItem)masterLayoutStructure.getDropZoneLayoutStructureItem();
        dropZoneLayoutStructureItem.addChildrenItem(layoutStructure.getMainItemId());
        LayoutStructureItem rootStructureItem = masterLayoutStructure.getLayoutStructureItem(layoutStructure.getMainItemId());
        rootStructureItem.setParentItemId(dropZoneLayoutStructureItem.getItemId());
        return masterLayoutStructure;
    }
}

