/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.util;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.UUID;

public class LayoutDataConverter {
    public static final int LATEST_VERSION = 1;

    public static String convert(String data) {
        if (Validator.isNull((String)data)) {
            return "";
        }
        JSONObject inputDataJSONObject = null;
        try {
            inputDataJSONObject = JSONFactoryUtil.createJSONObject((String)data);
        }
        catch (JSONException jsone) {
            throw new RuntimeException(jsone);
        }
        if (LayoutDataConverter.isLatestVersion(inputDataJSONObject)) {
            return data;
        }
        JSONArray structureJSONArray = inputDataJSONObject.getJSONArray("structure");
        if (structureJSONArray == null) {
            return data;
        }
        JSONObject itemsJSONObject = JSONFactoryUtil.createJSONObject();
        JSONArray mainChildrenJSONArray = JSONFactoryUtil.createJSONArray();
        UUID mainUUID = UUID.randomUUID();
        for (int i = 0; i < structureJSONArray.length(); ++i) {
            JSONObject inputRowJSONObject = structureJSONArray.getJSONObject(i);
            JSONArray columnsJSONArray = inputRowJSONObject.getJSONArray("columns");
            if (inputRowJSONObject.getInt("type") == 1) {
                UUID containerUUID = UUID.randomUUID();
                mainChildrenJSONArray.put((Object)containerUUID);
                UUID rowUUID = UUID.randomUUID();
                JSONArray rowChildrenJSONArray = JSONFactoryUtil.createJSONArray();
                for (int j = 0; j < columnsJSONArray.length(); ++j) {
                    JSONObject inputColumnJSONObject = columnsJSONArray.getJSONObject(j);
                    UUID columnUUID = UUID.randomUUID();
                    rowChildrenJSONArray.put(columnUUID.toString());
                    JSONArray columnChildrenJSONArray = JSONFactoryUtil.createJSONArray();
                    JSONArray fragmentEntryLinksJSONArray = inputColumnJSONObject.getJSONArray("fragmentEntryLinkIds");
                    for (int k = 0; k < fragmentEntryLinksJSONArray.length(); ++k) {
                        String fragmentEntryLinkId = fragmentEntryLinksJSONArray.getString(k);
                        UUID fragmentUUID = UUID.randomUUID();
                        columnChildrenJSONArray.put(fragmentUUID.toString());
                        JSONObject fragmentConfigJSONObject = JSONUtil.put((String)"fragmentEntryLinkId", (Object)fragmentEntryLinkId);
                        JSONObject fragmentJSONObject = LayoutDataConverter._getItemJSONObject(JSONFactoryUtil.createJSONArray(), fragmentConfigJSONObject, fragmentUUID.toString(), columnUUID.toString(), "fragment");
                        itemsJSONObject.put(fragmentUUID.toString(), fragmentJSONObject);
                    }
                    JSONObject columnConfigJSONObject = JSONUtil.put((String)"size", (Object)inputColumnJSONObject.getInt("size"));
                    JSONObject columnJSONObject = LayoutDataConverter._getItemJSONObject(columnChildrenJSONArray, columnConfigJSONObject, columnUUID.toString(), rowUUID.toString(), "column");
                    itemsJSONObject.put(columnUUID.toString(), columnJSONObject);
                }
                JSONObject inputRowConfigJSONObject = inputRowJSONObject.getJSONObject("config");
                JSONObject rowConfigJSONObject = JSONUtil.put((String)"gutters", (Object)inputRowConfigJSONObject.getBoolean("columnSpacing")).put("verticalAlign", "top");
                JSONObject rowJSONObject = LayoutDataConverter._getItemJSONObject(rowChildrenJSONArray, rowConfigJSONObject, rowUUID.toString(), containerUUID.toString(), "row");
                itemsJSONObject.put(rowUUID.toString(), rowJSONObject);
                JSONObject containerConfigJSONObject = JSONUtil.put((String)"backgroundColorCssClass", (Object)inputRowConfigJSONObject.getString("backgroundColorCssClass", null)).put("backgroundImage", inputRowConfigJSONObject.getJSONObject("backgroundImage")).put("paddingBottom", inputRowConfigJSONObject.getInt("paddingVertical")).put("paddingHorizontal", inputRowConfigJSONObject.getInt("paddingHorizontal")).put("paddingTop", inputRowConfigJSONObject.getInt("paddingVertical")).put("type", inputRowConfigJSONObject.getString("containerType", null));
                JSONObject containerJSONObject = LayoutDataConverter._getItemJSONObject(JSONUtil.put((Object)rowUUID.toString()), containerConfigJSONObject, containerUUID.toString(), mainUUID.toString(), "container");
                itemsJSONObject.put(containerUUID.toString(), containerJSONObject);
                continue;
            }
            UUID fragmentUUID = UUID.randomUUID();
            mainChildrenJSONArray.put(fragmentUUID.toString());
            JSONObject columnJSONObject = columnsJSONArray.getJSONObject(0);
            JSONArray fragmentEntryLinkIdsJSONArray = columnJSONObject.getJSONArray("fragmentEntryLinkIds");
            JSONObject fragmentConfigJSONObject = JSONUtil.put((String)"fragmentEntryLinkId", (Object)fragmentEntryLinkIdsJSONArray.get(0));
            JSONObject fragmentJSONObject = LayoutDataConverter._getItemJSONObject(JSONFactoryUtil.createJSONArray(), fragmentConfigJSONObject, fragmentUUID.toString(), mainUUID.toString(), "fragment");
            itemsJSONObject.put(fragmentUUID.toString(), fragmentJSONObject);
        }
        JSONObject mainJSONObject = LayoutDataConverter._getItemJSONObject(mainChildrenJSONArray, JSONFactoryUtil.createJSONObject(), mainUUID.toString(), "", "root");
        itemsJSONObject.put(mainUUID.toString(), mainJSONObject);
        JSONObject outputDataJSONObject = JSONUtil.put((String)"items", (Object)itemsJSONObject).put("rootItems", JSONUtil.put((String)"main", (Object)mainUUID.toString())).put("version", 1);
        return outputDataJSONObject.toJSONString();
    }

    public static boolean isLatestVersion(JSONObject dataJSONObject) {
        int version = dataJSONObject.getInt("version");
        return version == 1;
    }

    private static JSONObject _getItemJSONObject(JSONArray childrenJSONArray, JSONObject configJSONObject, String itemId, String parentId, String type) {
        return JSONUtil.put((String)"children", (Object)childrenJSONArray).put("config", configJSONObject).put("itemId", itemId).put("parentId", parentId).put("type", type);
    }
}

