/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.headless.delivery.dto.v1_0;

import com.liferay.fragment.contributor.FragmentCollectionContributor;
import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentCollection;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.model.FragmentEntryLink;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentCollectionLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLinkLocalServiceUtil;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.headless.delivery.dto.v1_0.Fragment;
import com.liferay.headless.delivery.dto.v1_0.FragmentField;
import com.liferay.headless.delivery.dto.v1_0.FragmentFieldBackgroundImage;
import com.liferay.headless.delivery.dto.v1_0.FragmentFieldHTML;
import com.liferay.headless.delivery.dto.v1_0.FragmentFieldImage;
import com.liferay.headless.delivery.dto.v1_0.FragmentFieldText;
import com.liferay.headless.delivery.dto.v1_0.FragmentImage;
import com.liferay.headless.delivery.dto.v1_0.FragmentInstanceDefinition;
import com.liferay.headless.delivery.dto.v1_0.FragmentLink;
import com.liferay.headless.delivery.dto.v1_0.InlineLink;
import com.liferay.headless.delivery.dto.v1_0.InlineValue;
import com.liferay.layout.util.structure.FragmentLayoutStructureItem;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;

public class FragmentInstanceDefinitionConverterUtil {
    public static FragmentInstanceDefinition toFragmentInstanceDefinition(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentEntryConfigurationParser fragmentEntryConfigurationParser, FragmentLayoutStructureItem fragmentLayoutStructureItem, FragmentRendererTracker fragmentRendererTracker) {
        return FragmentInstanceDefinitionConverterUtil.toFragmentInstanceDefinition(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentLayoutStructureItem, fragmentRendererTracker, true, true);
    }

    public static FragmentInstanceDefinition toFragmentInstanceDefinition(final FragmentCollectionContributorTracker fragmentCollectionContributorTracker, final FragmentEntryConfigurationParser fragmentEntryConfigurationParser, FragmentLayoutStructureItem fragmentLayoutStructureItem, final FragmentRendererTracker fragmentRendererTracker, final boolean saveInlineContent, boolean saveMappingConfiguration) {
        final FragmentEntryLink fragmentEntryLink = FragmentEntryLinkLocalServiceUtil.fetchFragmentEntryLink((long)fragmentLayoutStructureItem.getFragmentEntryLinkId());
        if (fragmentEntryLink == null) {
            return null;
        }
        final String rendererKey = fragmentEntryLink.getRendererKey();
        final FragmentEntry fragmentEntry = FragmentInstanceDefinitionConverterUtil._getFragmentEntry(fragmentCollectionContributorTracker, fragmentEntryLink.getFragmentEntryId(), rendererKey);
        return new FragmentInstanceDefinition(){
            {
                this.fragment = new Fragment(){
                    {
                        this.fragmentCollectionName = FragmentInstanceDefinitionConverterUtil._getFragmentCollectionName(fragmentCollectionContributorTracker, fragmentEntry, fragmentRendererTracker, rendererKey);
                        this.fragmentKey = FragmentInstanceDefinitionConverterUtil._getFragmentKey(fragmentEntry, rendererKey);
                        this.fragmentName = FragmentInstanceDefinitionConverterUtil._getFragmentName(fragmentEntry, fragmentEntryLink, fragmentRendererTracker, rendererKey);
                    }
                };
                this.fragmentConfig = FragmentInstanceDefinitionConverterUtil._getFragmentConfig(fragmentEntryConfigurationParser, fragmentEntryLink);
                this.fragmentFields = FragmentInstanceDefinitionConverterUtil._getFragmentFields(fragmentEntryLink, saveInlineContent);
            }
        };
    }

    private static List<FragmentField> _getBackgroundImageFragmentFields(JSONObject jsonObject) {
        ArrayList<FragmentField> fragmentFields = new ArrayList<FragmentField>();
        Set backgroundImageIds = jsonObject.keySet();
        for (final String backgroundImageId : backgroundImageIds) {
            JSONObject imageJSONObject = jsonObject.getJSONObject(backgroundImageId);
            final Map<String, String> localeMap = FragmentInstanceDefinitionConverterUtil._toLocaleMap(imageJSONObject);
            fragmentFields.add(new FragmentField(){
                {
                    this.id = backgroundImageId;
                    this.value = new FragmentFieldBackgroundImage(){
                        {
                            this.backgroundImage = new FragmentImage(){
                                {
                                    this.url = new InlineValue(){
                                        {
                                            this.value_i18n = localeMap;
                                        }
                                    };
                                }
                            };
                        }
                    };
                }
            });
        }
        return fragmentFields;
    }

    private static Map<String, String> _getEditableTypes(String html) {
        HashMap<String, String> editableTypes = new HashMap<String, String>();
        Document document = Jsoup.parse((String)html);
        Elements elements = document.getElementsByTag("lfr-editable");
        elements.forEach(element -> editableTypes.put(element.attr("id"), element.attr("type")));
        return editableTypes;
    }

    private static String _getFragmentCollectionName(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentEntry fragmentEntry, FragmentRendererTracker fragmentRendererTracker, String rendererKey) {
        if (fragmentEntry == null) {
            if (Validator.isNull((String)rendererKey)) {
                rendererKey = "FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY";
            }
            FragmentRenderer fragmentRenderer = fragmentRendererTracker.getFragmentRenderer(rendererKey);
            return LanguageUtil.get((ResourceBundle)ResourceBundleUtil.getBundle((Locale)LocaleUtil.getSiteDefault(), fragmentRenderer.getClass()), (String)("fragment.collection.label." + fragmentRenderer.getCollectionKey()));
        }
        FragmentCollection fragmentCollection = FragmentCollectionLocalServiceUtil.fetchFragmentCollection((long)fragmentEntry.getFragmentCollectionId());
        if (fragmentCollection != null) {
            return fragmentCollection.getName();
        }
        Object[] parts = StringUtil.split((String)rendererKey, (String)"-");
        if (ArrayUtil.isEmpty((Object[])parts)) {
            return null;
        }
        List fragmentCollectionContributors = fragmentCollectionContributorTracker.getFragmentCollectionContributors();
        for (FragmentCollectionContributor fragmentCollectionContributor : fragmentCollectionContributors) {
            if (!Objects.equals(fragmentCollectionContributor.getFragmentCollectionKey(), parts[0])) continue;
            return fragmentCollectionContributor.getName();
        }
        return null;
    }

    private static Map<String, Object> _getFragmentConfig(final FragmentEntryConfigurationParser fragmentEntryConfigurationParser, final FragmentEntryLink fragmentEntryLink) {
        try {
            return new HashMap<String, Object>(){
                {
                    JSONObject jsonObject = fragmentEntryConfigurationParser.getConfigurationJSONObject(fragmentEntryLink.getConfiguration(), fragmentEntryLink.getEditableValues(), new long[]{0L});
                    Set keys = jsonObject.keySet();
                    for (String key : keys) {
                        Object value = jsonObject.get(key);
                        if (value instanceof JSONObject) {
                            JSONObject valueJSONObject = (JSONObject)value;
                            value = FragmentInstanceDefinitionConverterUtil._toMap(valueJSONObject);
                        }
                        this.put(key, value);
                    }
                }
            };
        }
        catch (JSONException jsonException) {
            return null;
        }
    }

    private static FragmentEntry _getFragmentEntry(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, long fragmentEntryId, String rendererKey) {
        FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.fetchFragmentEntry((long)fragmentEntryId);
        if (fragmentEntry != null) {
            return fragmentEntry;
        }
        Map fragmentEntries = fragmentCollectionContributorTracker.getFragmentEntries();
        return (FragmentEntry)fragmentEntries.get(rendererKey);
    }

    private static FragmentField[] _getFragmentFields(FragmentEntryLink fragmentEntryLink, boolean saveInlineContent) {
        if (!saveInlineContent) {
            return new FragmentField[0];
        }
        JSONObject editableValuesJSONObject = null;
        try {
            editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
        }
        catch (JSONException jsonException) {
            return null;
        }
        ArrayList<FragmentField> fragmentFields = new ArrayList<FragmentField>();
        fragmentFields.addAll(FragmentInstanceDefinitionConverterUtil._getBackgroundImageFragmentFields(editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.background.image.BackgroundImageFragmentEntryProcessor")));
        Map<String, String> editableTypes = FragmentInstanceDefinitionConverterUtil._getEditableTypes(fragmentEntryLink.getHtml());
        fragmentFields.addAll(FragmentInstanceDefinitionConverterUtil._getTextFragmentFields(editableTypes, editableValuesJSONObject.getJSONObject("com.liferay.fragment.entry.processor.editable.EditableFragmentEntryProcessor")));
        return fragmentFields.toArray(new FragmentField[0]);
    }

    private static String _getFragmentKey(FragmentEntry fragmentEntry, String rendererKey) {
        if (fragmentEntry != null) {
            return fragmentEntry.getFragmentEntryKey();
        }
        return rendererKey;
    }

    private static String _getFragmentName(FragmentEntry fragmentEntry, FragmentEntryLink fragmentEntryLink, FragmentRendererTracker fragmentRendererTracker, String rendererKey) {
        if (fragmentEntry != null) {
            return fragmentEntry.getName();
        }
        JSONObject editableValuesJSONObject = null;
        try {
            editableValuesJSONObject = JSONFactoryUtil.createJSONObject((String)fragmentEntryLink.getEditableValues());
        }
        catch (JSONException jsonException) {
            return null;
        }
        String portletId = editableValuesJSONObject.getString("portletId");
        if (Validator.isNotNull((String)portletId)) {
            return PortalUtil.getPortletTitle((String)portletId, (Locale)LocaleUtil.getSiteDefault());
        }
        if (Validator.isNull((String)rendererKey)) {
            rendererKey = "FRAGMENT_ENTRY_FRAGMENT_RENDERER_KEY";
        }
        FragmentRenderer fragmentRenderer = fragmentRendererTracker.getFragmentRenderer(rendererKey);
        return fragmentRenderer.getLabel(LocaleUtil.getSiteDefault());
    }

    private static List<FragmentField> _getTextFragmentFields(Map<String, String> editableTypes, JSONObject jsonObject) {
        ArrayList<FragmentField> fragmentFields = new ArrayList<FragmentField>();
        Set textIds = jsonObject.keySet();
        for (String textId : textIds) {
            fragmentFields.add(FragmentInstanceDefinitionConverterUtil._toFragmentField(editableTypes, jsonObject, textId));
        }
        return fragmentFields;
    }

    private static FragmentField _toFragmentField(final Map<String, String> editableTypes, JSONObject jsonObject, final String textId) {
        final JSONObject textJSONObject = jsonObject.getJSONObject(textId);
        return new FragmentField(){
            {
                this.id = textId;
                this.setValue(() -> {
                    String type = editableTypes.getOrDefault(textId, "text");
                    if (Objects.equals(type, "html")) {
                        return FragmentInstanceDefinitionConverterUtil._toFragmentFieldHTML(textJSONObject);
                    }
                    if (Objects.equals(type, "image")) {
                        return FragmentInstanceDefinitionConverterUtil._toFragmentFieldImage(textJSONObject);
                    }
                    return FragmentInstanceDefinitionConverterUtil._toFragmentFieldText(textJSONObject);
                });
            }
        };
    }

    private static FragmentFieldHTML _toFragmentFieldHTML(final JSONObject jsonObject) {
        return new FragmentFieldHTML(){
            {
                this.html = new InlineValue(){
                    {
                        this.value_i18n = FragmentInstanceDefinitionConverterUtil._toLocaleMap(jsonObject);
                    }
                };
            }
        };
    }

    private static FragmentFieldImage _toFragmentFieldImage(final JSONObject jsonObject) {
        final Map<String, String> localeMap = FragmentInstanceDefinitionConverterUtil._toLocaleMap(jsonObject);
        return new FragmentFieldImage(){
            {
                this.fragmentImage = new FragmentImage(){
                    {
                        this.url = new InlineValue(){
                            {
                                this.value_i18n = localeMap;
                            }
                        };
                    }
                };
                this.fragmentLink = FragmentInstanceDefinitionConverterUtil._toFragmentLink(jsonObject);
            }
        };
    }

    private static FragmentFieldText _toFragmentFieldText(final JSONObject jsonObject) {
        return new FragmentFieldText(){
            {
                this.fragmentLink = FragmentInstanceDefinitionConverterUtil._toFragmentLink(jsonObject);
                this.text = new InlineValue(){
                    {
                        this.value_i18n = FragmentInstanceDefinitionConverterUtil._toLocaleMap(jsonObject);
                    }
                };
            }
        };
    }

    private static FragmentLink _toFragmentLink(JSONObject jsonObject) {
        final JSONObject configJSONObject = jsonObject.getJSONObject("config");
        if (configJSONObject.isNull("href")) {
            return null;
        }
        return new FragmentLink(){
            {
                this.value = new InlineLink(){
                    {
                        this.href = configJSONObject.getString("href");
                    }
                };
                this.setTarget(() -> {
                    String target = configJSONObject.getString("target");
                    if (Validator.isNull((String)target)) {
                        return null;
                    }
                    return FragmentLink.Target.create((String)StringUtil.upperCaseFirstLetter((String)target.substring(1)));
                });
            }
        };
    }

    private static Map<String, String> _toLocaleMap(final JSONObject jsonObject) {
        return new HashMap<String, String>(){
            {
                Set keys = jsonObject.keySet();
                for (String key : keys) {
                    if (key.equals("classNameId") || key.equals("classPK") || key.equals("config") || key.equals("defaultValue") || key.equals("fieldId")) continue;
                    this.put(key, jsonObject.getString(key));
                }
            }
        };
    }

    private static Map<String, String> _toMap(final JSONObject jsonObject) {
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                Set keys = jsonObject.keySet();
                for (String key : keys) {
                    String value = jsonObject.getString(key);
                    if (!Validator.isNotNull((String)value)) continue;
                    this.put(key, value);
                }
            }
        };
        if (map.isEmpty()) {
            return null;
        }
        return map;
    }
}

