/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.headless.delivery.dto.v1_0;

import com.liferay.fragment.contributor.FragmentCollectionContributorTracker;
import com.liferay.fragment.model.FragmentEntry;
import com.liferay.fragment.renderer.FragmentRenderer;
import com.liferay.fragment.renderer.FragmentRendererTracker;
import com.liferay.fragment.service.FragmentEntryLocalServiceUtil;
import com.liferay.fragment.util.configuration.FragmentEntryConfigurationParser;
import com.liferay.headless.delivery.dto.v1_0.ColumnDefinition;
import com.liferay.headless.delivery.dto.v1_0.DropZoneDefinition;
import com.liferay.headless.delivery.dto.v1_0.Fragment;
import com.liferay.headless.delivery.dto.v1_0.FragmentImage;
import com.liferay.headless.delivery.dto.v1_0.InlineValue;
import com.liferay.headless.delivery.dto.v1_0.Layout;
import com.liferay.headless.delivery.dto.v1_0.MasterPage;
import com.liferay.headless.delivery.dto.v1_0.PageDefinition;
import com.liferay.headless.delivery.dto.v1_0.PageElement;
import com.liferay.headless.delivery.dto.v1_0.RowDefinition;
import com.liferay.headless.delivery.dto.v1_0.SectionDefinition;
import com.liferay.headless.delivery.dto.v1_0.Settings;
import com.liferay.layout.page.template.headless.delivery.dto.v1_0.FragmentInstanceDefinitionConverterUtil;
import com.liferay.layout.page.template.model.LayoutPageTemplateEntry;
import com.liferay.layout.page.template.model.LayoutPageTemplateStructure;
import com.liferay.layout.page.template.service.LayoutPageTemplateEntryLocalServiceUtil;
import com.liferay.layout.page.template.service.LayoutPageTemplateStructureLocalServiceUtil;
import com.liferay.layout.page.template.util.PaddingConverter;
import com.liferay.layout.util.structure.ColumnLayoutStructureItem;
import com.liferay.layout.util.structure.ContainerLayoutStructureItem;
import com.liferay.layout.util.structure.DropZoneLayoutStructureItem;
import com.liferay.layout.util.structure.FragmentLayoutStructureItem;
import com.liferay.layout.util.structure.LayoutStructure;
import com.liferay.layout.util.structure.LayoutStructureItem;
import com.liferay.layout.util.structure.RootLayoutStructureItem;
import com.liferay.layout.util.structure.RowLayoutStructureItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PageDefinitionConverterUtil {
    private static final Log _log = LogFactoryUtil.getLog(PageDefinitionConverterUtil.class);

    public static PageDefinition toPageDefinition(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentEntryConfigurationParser fragmentEntryConfigurationParser, FragmentRendererTracker fragmentRendererTracker, Layout layout) {
        return PageDefinitionConverterUtil.toPageDefinition(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentRendererTracker, layout, true, true);
    }

    public static PageDefinition toPageDefinition(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentEntryConfigurationParser fragmentEntryConfigurationParser, FragmentRendererTracker fragmentRendererTracker, Layout layout, boolean saveInlineContent, boolean saveMappingConfiguration) {
        return PageDefinitionConverterUtil.toPageDefinition(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentRendererTracker, layout, saveInlineContent, saveMappingConfiguration, 0L);
    }

    public static PageDefinition toPageDefinition(final FragmentCollectionContributorTracker fragmentCollectionContributorTracker, final FragmentEntryConfigurationParser fragmentEntryConfigurationParser, final FragmentRendererTracker fragmentRendererTracker, final Layout layout, final boolean saveInlineContent, final boolean saveMappingConfiguration, final long segmentsExperienceId) {
        return new PageDefinition(){
            {
                this.pageElement = PageDefinitionConverterUtil._toPageElement(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentRendererTracker, layout, saveInlineContent, saveMappingConfiguration, segmentsExperienceId);
                this.settings = PageDefinitionConverterUtil._toSettings(layout);
            }
        };
    }

    @Deprecated
    public static PageElement toPageElement(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentEntryConfigurationParser fragmentEntryConfigurationParser, FragmentRendererTracker fragmentRendererTracker, LayoutStructure layoutStructure, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, boolean saveMappingConfiguration) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public static PageElement toPageElement(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentEntryConfigurationParser fragmentEntryConfigurationParser, FragmentRendererTracker fragmentRendererTracker, LayoutStructure layoutStructure, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, boolean saveMappingConfiguration, long segmentsExperienceId) {
        throw new UnsupportedOperationException();
    }

    public static PageElement toPageElement(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentEntryConfigurationParser fragmentEntryConfigurationParser, FragmentRendererTracker fragmentRendererTracker, long groupId, LayoutStructure layoutStructure, LayoutStructureItem layoutStructureItem, boolean saveInlineContent, boolean saveMappingConfiguration, long segmentsExperienceId) {
        ArrayList<PageElement> pageElements = new ArrayList<PageElement>();
        List childrenItemIds = layoutStructureItem.getChildrenItemIds();
        for (String childItemId : childrenItemIds) {
            LayoutStructureItem childLayoutStructureItem = layoutStructure.getLayoutStructureItem(childItemId);
            List grandChildrenItemIds = childLayoutStructureItem.getChildrenItemIds();
            if (grandChildrenItemIds.isEmpty()) {
                pageElements.add(PageDefinitionConverterUtil._toPageElement(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentRendererTracker, groupId, childLayoutStructureItem, saveInlineContent, saveMappingConfiguration, segmentsExperienceId));
                continue;
            }
            pageElements.add(PageDefinitionConverterUtil.toPageElement(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentRendererTracker, groupId, layoutStructure, childLayoutStructureItem, saveInlineContent, saveMappingConfiguration, segmentsExperienceId));
        }
        PageElement pageElement = PageDefinitionConverterUtil._toPageElement(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentRendererTracker, groupId, layoutStructureItem, saveInlineContent, saveMappingConfiguration, segmentsExperienceId);
        if (!pageElements.isEmpty()) {
            pageElement.setPageElements(pageElements.toArray(new PageElement[0]));
        }
        return pageElement;
    }

    private static boolean _isFragmentEntryKey(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, String fragmentEntryKey, FragmentRendererTracker fragmentRendererTracker, long groupId) {
        FragmentEntry fragmentEntry = FragmentEntryLocalServiceUtil.fetchFragmentEntry((long)groupId, (String)fragmentEntryKey);
        if (fragmentEntry != null) {
            return true;
        }
        Map fragmentEntries = fragmentCollectionContributorTracker.getFragmentEntries();
        fragmentEntry = (FragmentEntry)fragmentEntries.get(fragmentEntryKey);
        if (fragmentEntry != null) {
            return true;
        }
        FragmentRenderer fragmentRenderer = fragmentRendererTracker.getFragmentRenderer(fragmentEntryKey);
        return fragmentRenderer != null;
    }

    private static Fragment[] _toFragments(List<String> fragmentEntryKeys, FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentRendererTracker fragmentRendererTracker, long groupId) {
        ArrayList<2> fragments = new ArrayList<2>();
        for (final String fragmentEntryKey : fragmentEntryKeys) {
            if (!PageDefinitionConverterUtil._isFragmentEntryKey(fragmentCollectionContributorTracker, fragmentEntryKey, fragmentRendererTracker, groupId)) continue;
            fragments.add(new Fragment(){
                {
                    this.key = fragmentEntryKey;
                }
            });
        }
        return fragments.toArray(new Fragment[0]);
    }

    private static Map<String, Fragment[]> _toFragmentSettingsMap(DropZoneLayoutStructureItem dropZoneLayoutStructureItem, FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentRendererTracker fragmentRendererTracker, long groupId) {
        if (dropZoneLayoutStructureItem.isAllowNewFragmentEntries()) {
            return HashMapBuilder.put((Object)"unallowedFragments", (Object)PageDefinitionConverterUtil._toFragments(dropZoneLayoutStructureItem.getFragmentEntryKeys(), fragmentCollectionContributorTracker, fragmentRendererTracker, groupId)).build();
        }
        return HashMapBuilder.put((Object)"allowedFragments", (Object)PageDefinitionConverterUtil._toFragments(dropZoneLayoutStructureItem.getFragmentEntryKeys(), fragmentCollectionContributorTracker, fragmentRendererTracker, groupId)).build();
    }

    private static PageElement _toPageElement(FragmentCollectionContributorTracker fragmentCollectionContributorTracker, FragmentEntryConfigurationParser fragmentEntryConfigurationParser, FragmentRendererTracker fragmentRendererTracker, Layout layout, boolean saveInlineContent, boolean saveMappingConfiguration, long segmentsExperienceId) {
        LayoutPageTemplateStructure layoutPageTemplateStructure = LayoutPageTemplateStructureLocalServiceUtil.fetchLayoutPageTemplateStructure(layout.getGroupId(), PortalUtil.getClassNameId(Layout.class), layout.getPlid());
        LayoutStructure layoutStructure = LayoutStructure.of((String)layoutPageTemplateStructure.getData(0L));
        LayoutStructureItem mainLayoutStructureItem = layoutStructure.getMainLayoutStructureItem();
        ArrayList<PageElement> mainPageElements = new ArrayList<PageElement>();
        for (String childItemId : mainLayoutStructureItem.getChildrenItemIds()) {
            mainPageElements.add(PageDefinitionConverterUtil.toPageElement(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentRendererTracker, layout.getGroupId(), layoutStructure, layoutStructure.getLayoutStructureItem(childItemId), saveInlineContent, saveMappingConfiguration, 0L));
        }
        PageElement pageElement = PageDefinitionConverterUtil._toPageElement(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentRendererTracker, layout.getGroupId(), mainLayoutStructureItem, saveInlineContent, saveMappingConfiguration, segmentsExperienceId);
        if (!mainPageElements.isEmpty()) {
            pageElement.setPageElements(mainPageElements.toArray(new PageElement[0]));
        }
        return pageElement;
    }

    private static PageElement _toPageElement(final FragmentCollectionContributorTracker fragmentCollectionContributorTracker, final FragmentEntryConfigurationParser fragmentEntryConfigurationParser, final FragmentRendererTracker fragmentRendererTracker, final long groupId, LayoutStructureItem layoutStructureItem, final boolean saveInlineContent, final boolean saveMappingConfiguration, final long segmentsExperienceId) {
        if (layoutStructureItem instanceof ColumnLayoutStructureItem) {
            final ColumnLayoutStructureItem columnLayoutStructureItem = (ColumnLayoutStructureItem)layoutStructureItem;
            return new PageElement(){
                {
                    this.definition = new ColumnDefinition(){
                        {
                            this.size = columnLayoutStructureItem.getSize();
                        }
                    };
                    this.type = PageElement.Type.COLUMN;
                }
            };
        }
        if (layoutStructureItem instanceof ContainerLayoutStructureItem) {
            final ContainerLayoutStructureItem containerLayoutStructureItem = (ContainerLayoutStructureItem)layoutStructureItem;
            return new PageElement(){
                {
                    this.definition = new SectionDefinition(){
                        {
                            this.backgroundColor = GetterUtil.getString((String)containerLayoutStructureItem.getBackgroundColorCssClass(), null);
                            this.layout = new com.liferay.headless.delivery.dto.v1_0.Layout(){
                                {
                                    this.paddingBottom = PaddingConverter.convertToExternalValue(containerLayoutStructureItem.getPaddingBottom());
                                    this.paddingHorizontal = PaddingConverter.convertToExternalValue(containerLayoutStructureItem.getPaddingHorizontal());
                                    this.paddingTop = PaddingConverter.convertToExternalValue(containerLayoutStructureItem.getPaddingTop());
                                    this.setContainerType(() -> {
                                        String containerType = containerLayoutStructureItem.getContainerType();
                                        if (Validator.isNull((String)containerType)) {
                                            return null;
                                        }
                                        return Layout.ContainerType.create((String)StringUtil.upperCaseFirstLetter((String)containerType));
                                    });
                                }
                            };
                            this.setBackgroundImage(() -> {
                                final JSONObject backgroundImageJSONObject = containerLayoutStructureItem.getBackgroundImageJSONObject();
                                if (backgroundImageJSONObject == null || !backgroundImageJSONObject.has("url")) {
                                    return null;
                                }
                                final String urlValue = backgroundImageJSONObject.getString("url");
                                return new FragmentImage(){
                                    {
                                        this.title = PageDefinitionConverterUtil._toTitleInlineValue(backgroundImageJSONObject, urlValue);
                                        this.url = new InlineValue(){
                                            {
                                                this.value = urlValue;
                                            }
                                        };
                                    }
                                };
                            });
                        }
                    };
                    this.type = PageElement.Type.SECTION;
                }
            };
        }
        if (layoutStructureItem instanceof DropZoneLayoutStructureItem) {
            final DropZoneLayoutStructureItem dropZoneLayoutStructureItem = (DropZoneLayoutStructureItem)layoutStructureItem;
            return new PageElement(){
                {
                    this.definition = new DropZoneDefinition(){
                        {
                            this.fragmentSettings = PageDefinitionConverterUtil._toFragmentSettingsMap(dropZoneLayoutStructureItem, fragmentCollectionContributorTracker, fragmentRendererTracker, groupId);
                        }
                    };
                    this.type = PageElement.Type.DROP_ZONE;
                }
            };
        }
        if (layoutStructureItem instanceof FragmentLayoutStructureItem) {
            final FragmentLayoutStructureItem fragmentLayoutStructureItem = (FragmentLayoutStructureItem)layoutStructureItem;
            return new PageElement(){
                {
                    this.definition = FragmentInstanceDefinitionConverterUtil.toFragmentInstanceDefinition(fragmentCollectionContributorTracker, fragmentEntryConfigurationParser, fragmentLayoutStructureItem, fragmentRendererTracker, saveInlineContent, saveMappingConfiguration, segmentsExperienceId);
                    this.type = PageElement.Type.FRAGMENT;
                }
            };
        }
        if (layoutStructureItem instanceof RootLayoutStructureItem) {
            return new PageElement(){
                {
                    this.type = PageElement.Type.ROOT;
                }
            };
        }
        if (layoutStructureItem instanceof RowLayoutStructureItem) {
            final RowLayoutStructureItem rowLayoutStructureItem = (RowLayoutStructureItem)layoutStructureItem;
            return new PageElement(){
                {
                    this.definition = new RowDefinition(){
                        {
                            this.gutters = rowLayoutStructureItem.isGutters();
                            this.numberOfColumns = rowLayoutStructureItem.getNumberOfColumns();
                        }
                    };
                    this.type = PageElement.Type.ROW;
                }
            };
        }
        return null;
    }

    private static Settings _toSettings(final Layout layout) {
        final UnicodeProperties unicodeProperties = layout.getTypeSettingsProperties();
        return new Settings(){
            {
                this.setColorSchemeName(() -> {
                    ColorScheme colorScheme;
                    block3: {
                        colorScheme = null;
                        try {
                            colorScheme = layout.getColorScheme();
                        }
                        catch (PortalException portalException) {
                            if (!_log.isWarnEnabled()) break block3;
                            _log.warn((Object)portalException, (Throwable)portalException);
                        }
                    }
                    if (colorScheme == null) {
                        return null;
                    }
                    return colorScheme.getName();
                });
                this.setCss(() -> {
                    if (Validator.isNull((String)layout.getCss())) {
                        return null;
                    }
                    return layout.getCss();
                });
                this.setJavascript(() -> {
                    for (Map.Entry entry : unicodeProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.equals("javascript")) continue;
                        return (String)entry.getValue();
                    }
                    return null;
                });
                this.setMasterPage(() -> {
                    final LayoutPageTemplateEntry layoutPageTemplateEntry = LayoutPageTemplateEntryLocalServiceUtil.fetchLayoutPageTemplateEntryByPlid(layout.getMasterLayoutPlid());
                    if (layoutPageTemplateEntry == null) {
                        return null;
                    }
                    return new MasterPage(){
                        {
                            this.name = layoutPageTemplateEntry.getName();
                        }
                    };
                });
                this.setThemeName(() -> {
                    Theme theme = layout.getTheme();
                    if (theme == null) {
                        return null;
                    }
                    return theme.getName();
                });
                this.setThemeSettings(() -> {
                    UnicodeProperties themeSettingsUnicodeProperties = new UnicodeProperties();
                    for (Map.Entry entry : unicodeProperties.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!key.startsWith("lfr-theme:")) continue;
                        themeSettingsUnicodeProperties.setProperty(key, (String)entry.getValue());
                    }
                    if (themeSettingsUnicodeProperties.isEmpty()) {
                        return null;
                    }
                    return themeSettingsUnicodeProperties;
                });
            }
        };
    }

    private static InlineValue _toTitleInlineValue(JSONObject jsonObject, String urlValue) {
        final String title = jsonObject.getString("title");
        if (Validator.isNull((String)title) || title.equals(urlValue)) {
            return null;
        }
        return new InlineValue(){
            {
                this.value = title;
            }
        };
    }
}

