/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.layout.page.template.internal.upgrade.v1_1_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.LayoutPrototype;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.LayoutPrototypeLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class LayoutPrototypeUpgradeProcess
extends UpgradeProcess {
    private static final int _MAX_NAME_LENGTH = 75;
    private static final Log _log = LogFactoryUtil.getLog(LayoutPrototypeUpgradeProcess.class);
    private final CompanyLocalService _companyLocalService;
    private final LayoutPrototypeLocalService _layoutPrototypeLocalService;

    public LayoutPrototypeUpgradeProcess(CompanyLocalService companyLocalService, LayoutPrototypeLocalService layoutPrototypeLocalService) {
        this._companyLocalService = companyLocalService;
        this._layoutPrototypeLocalService = layoutPrototypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.upgradeSchema();
        this.upgradeLayoutPrototype();
    }

    protected void upgradeLayoutPrototype() throws Exception {
        Date date = new Date(System.currentTimeMillis());
        StringBundler sb = new StringBundler(6);
        sb.append("insert into LayoutPageTemplateEntry (uuid_, ");
        sb.append("layoutPageTemplateEntryId, groupId, companyId, userId, ");
        sb.append("userName, createDate, modifiedDate, ");
        sb.append("layoutPageTemplateCollectionId, name, type_, ");
        sb.append("layoutPrototypeId, status) values (?, ?, ?, ?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?)");
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)sb.toString());){
            HashSet<String> existingNames = new HashSet<String>();
            List layoutPrototypes = this._layoutPrototypeLocalService.getLayoutPrototypes(-1, -1);
            for (LayoutPrototype layoutPrototype : layoutPrototypes) {
                Locale defaultLocale;
                String nameXML = layoutPrototype.getName();
                Company company = this._companyLocalService.getCompany(layoutPrototype.getCompanyId());
                Map nameMap = LocalizationUtil.getLocalizationMap((String)nameXML);
                String name = (String)nameMap.get(defaultLocale = LocaleUtil.fromLanguageId((String)LocalizationUtil.getDefaultLanguageId((String)nameXML)));
                if (existingNames.contains(name)) {
                    name = this._generateNewName(name, existingNames);
                    nameMap.put(defaultLocale, name);
                    layoutPrototype.setNameMap(nameMap);
                    layoutPrototype = this._layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototype);
                }
                if (layoutPrototype.getCreateDate() == null || layoutPrototype.getModifiedDate() == null) {
                    if (layoutPrototype.getCreateDate() == null) {
                        layoutPrototype.setCreateDate((java.util.Date)date);
                    }
                    if (layoutPrototype.getModifiedDate() == null) {
                        layoutPrototype.setModifiedDate((java.util.Date)date);
                    }
                    this._layoutPrototypeLocalService.updateLayoutPrototype(layoutPrototype);
                }
                existingNames.add(name);
                preparedStatement.setString(1, layoutPrototype.getUuid());
                preparedStatement.setLong(2, this.increment());
                preparedStatement.setLong(3, company.getGroupId());
                preparedStatement.setLong(4, layoutPrototype.getCompanyId());
                preparedStatement.setLong(5, layoutPrototype.getUserId());
                preparedStatement.setString(6, layoutPrototype.getUserName());
                preparedStatement.setDate(7, date);
                preparedStatement.setDate(8, date);
                preparedStatement.setLong(9, 0L);
                preparedStatement.setString(10, name);
                preparedStatement.setInt(11, 2);
                preparedStatement.setLong(12, layoutPrototype.getLayoutPrototypeId());
                preparedStatement.setInt(13, 0);
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
    }

    protected void upgradeSchema() throws Exception {
        String template = StringUtil.read((InputStream)LayoutPrototypeUpgradeProcess.class.getResourceAsStream("dependencies/update.sql"));
        this.runSQLTemplateString(template, false);
    }

    private String _generateNewName(String name, Set<String> existingNames) {
        String newName;
        int i = 1;
        while (true) {
            String suffix = "-" + i;
            newName = name + suffix;
            if (newName.length() > 75) {
                String prefix = name.substring(0, 75 - suffix.length());
                newName = prefix + suffix;
            }
            if (!existingNames.contains(newName)) break;
            ++i;
        }
        if (_log.isWarnEnabled()) {
            _log.warn((Object)StringBundler.concat((String[])new String[]{"Renaming duplicate layout prototype name \"", name, "\" to \"", newName, "\""}));
        }
        return newName;
    }
}

